/*
 * Decompiled with CFR 0.152.
 */
package dji.v5.ux.mapkit.maplibre.annotations;

import androidx.annotation.ColorInt;
import com.mapbox.geojson.Geometry;
import com.mapbox.geojson.LineString;
import com.mapbox.geojson.Point;
import com.mapbox.mapboxsdk.geometry.LatLng;
import com.mapbox.mapboxsdk.maps.MapboxMap;
import com.mapbox.mapboxsdk.maps.Style;
import com.mapbox.mapboxsdk.style.layers.Layer;
import com.mapbox.mapboxsdk.style.layers.LineLayer;
import com.mapbox.mapboxsdk.style.layers.PropertyFactory;
import com.mapbox.mapboxsdk.style.layers.PropertyValue;
import com.mapbox.mapboxsdk.style.sources.GeoJsonSource;
import com.mapbox.mapboxsdk.style.sources.Source;
import dji.v5.ux.mapkit.core.models.DJILatLng;
import dji.v5.ux.mapkit.core.models.annotations.DJIPolyline;
import dji.v5.ux.mapkit.core.models.annotations.DJIPolylineOptions;
import dji.v5.ux.mapkit.core.utils.DJIMapkitLog;
import dji.v5.ux.mapkit.maplibre.utils.MapboxExtension;
import dji.v5.ux.mapkit.maplibre.utils.MapboxUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 72\u00020\u0001:\u00017B\u0087\u0001\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00126\u0010\u0006\u001a2\u0012\u0013\u0012\u00110\b\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\u000b\u0012\u0013\u0012\u00110\u0000\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\f\u0012\u0004\u0012\u00020\r0\u0007\u00126\u0010\u000e\u001a2\u0012\u0013\u0012\u00110\b\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\u000b\u0012\u0013\u0012\u00110\u0000\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\f\u0012\u0004\u0012\u00020\u000f0\u0007\u00a2\u0006\u0004\b\u0010\u0010\u0011J\b\u0010\u001f\u001a\u00020\u000fH\u0016J\u0010\u0010 \u001a\u00020\u000f2\u0006\u0010!\u001a\u00020\"H\u0016J\b\u0010#\u001a\u00020\"H\u0016J\u0016\u0010$\u001a\u00020\u000f2\f\u0010%\u001a\b\u0012\u0004\u0012\u00020'0&H\u0016J\u000e\u0010(\u001a\b\u0012\u0004\u0012\u00020'0)H\u0016J\u0012\u0010*\u001a\u00020\u000f2\b\b\u0001\u0010+\u001a\u00020\bH\u0016J\b\u0010,\u001a\u00020\bH\u0017J\r\u0010-\u001a\u00020\u000fH\u0000\u00a2\u0006\u0002\b.J\r\u0010/\u001a\u00020\u000fH\u0000\u00a2\u0006\u0002\b0J\u0010\u00101\u001a\u00020\u000f2\u0006\u00102\u001a\u000203H\u0002J\b\u00104\u001a\u00020\"H\u0016J\u0010\u00105\u001a\u00020\u000f2\u0006\u00106\u001a\u00020\"H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R>\u0010\u0006\u001a2\u0012\u0013\u0012\u00110\b\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\u000b\u0012\u0013\u0012\u00110\u0000\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\f\u0012\u0004\u0012\u00020\r0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R>\u0010\u000e\u001a2\u0012\u0013\u0012\u00110\b\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\u000b\u0012\u0013\u0012\u00110\u0000\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\f\u0012\u0004\u0012\u00020\u000f0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0014\u001a\u00020\u00158BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0018\u0010\u0019\u001a\u0004\b\u0016\u0010\u0017R\u001b\u0010\u001a\u001a\u00020\u001b8@X\u0080\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001e\u0010\u0019\u001a\u0004\b\u001c\u0010\u001d\u00a8\u00068"}, d2={"Ldji/v5/ux/mapkit/maplibre/annotations/MaplibrePolyline;", "Ldji/v5/ux/mapkit/core/models/annotations/DJIPolyline;", "mapboxMap", "Lcom/mapbox/mapboxsdk/maps/MapboxMap;", "options", "Ldji/v5/ux/mapkit/core/models/annotations/DJIPolylineOptions;", "onRemovePolyline", "Lkotlin/Function2;", "", "Lkotlin/ParameterName;", "name", "zindex", "polyline", "", "onAddPolyline", "", "<init>", "(Lcom/mapbox/mapboxsdk/maps/MapboxMap;Ldji/v5/ux/mapkit/core/models/annotations/DJIPolylineOptions;Lkotlin/jvm/functions/Function2;Lkotlin/jvm/functions/Function2;)V", "getOptions", "()Ldji/v5/ux/mapkit/core/models/annotations/DJIPolylineOptions;", "source", "Lcom/mapbox/mapboxsdk/style/sources/GeoJsonSource;", "getSource", "()Lcom/mapbox/mapboxsdk/style/sources/GeoJsonSource;", "source$delegate", "Lkotlin/Lazy;", "polylineLayer", "Lcom/mapbox/mapboxsdk/style/layers/LineLayer;", "getPolylineLayer$android_sdk_v5_uxsdk_release", "()Lcom/mapbox/mapboxsdk/style/layers/LineLayer;", "polylineLayer$delegate", "remove", "setWidth", "width", "", "getWidth", "setPoints", "points", "", "Ldji/v5/ux/mapkit/core/models/DJILatLng;", "getPoints", "", "setColor", "color", "getColor", "clear", "clear$android_sdk_v5_uxsdk_release", "restore", "restore$android_sdk_v5_uxsdk_release", "setUpPolylineSource", "style", "Lcom/mapbox/mapboxsdk/maps/Style;", "getZIndex", "setZIndex", "zIndex", "Companion", "android-sdk-v5-uxsdk_release"})
@SourceDebugExtension(value={"SMAP\nMaplibrePolyline.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MaplibrePolyline.kt\ndji/v5/ux/mapkit/maplibre/annotations/MaplibrePolyline\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,118:1\n1549#2:119\n1620#2,3:120\n1549#2:123\n1620#2,3:124\n1549#2:128\n1620#2,3:129\n1549#2:132\n1620#2,3:133\n1#3:127\n*S KotlinDebug\n*F\n+ 1 MaplibrePolyline.kt\ndji/v5/ux/mapkit/maplibre/annotations/MaplibrePolyline\n*L\n68#1:119\n68#1:120,3\n69#1:123\n69#1:124,3\n24#1:128\n24#1:129,3\n25#1:132\n25#1:133,3\n*E\n"})
public final class MaplibrePolyline
implements DJIPolyline {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final MapboxMap mapboxMap;
    @NotNull
    private final DJIPolylineOptions options;
    @NotNull
    private final Function2<Integer, MaplibrePolyline, Boolean> onRemovePolyline;
    @NotNull
    private final Function2<Integer, MaplibrePolyline, Unit> onAddPolyline;
    @NotNull
    private final Lazy source$delegate;
    @NotNull
    private final Lazy polylineLayer$delegate;
    @NotNull
    private static final String TAG = "MaplibrePolyline";

    public MaplibrePolyline(@NotNull MapboxMap mapboxMap, @NotNull DJIPolylineOptions options, @NotNull Function2<? super Integer, ? super MaplibrePolyline, Boolean> onRemovePolyline, @NotNull Function2<? super Integer, ? super MaplibrePolyline, Unit> onAddPolyline) {
        block1: {
            Intrinsics.checkNotNullParameter((Object)mapboxMap, (String)"mapboxMap");
            Intrinsics.checkNotNullParameter((Object)options, (String)"options");
            Intrinsics.checkNotNullParameter(onRemovePolyline, (String)"onRemovePolyline");
            Intrinsics.checkNotNullParameter(onAddPolyline, (String)"onAddPolyline");
            this.mapboxMap = mapboxMap;
            this.options = options;
            this.onRemovePolyline = onRemovePolyline;
            this.onAddPolyline = onAddPolyline;
            this.source$delegate = LazyKt.lazy(() -> MaplibrePolyline.source_delegate$lambda$3(this));
            this.polylineLayer$delegate = LazyKt.lazy(() -> MaplibrePolyline.polylineLayer_delegate$lambda$4(this));
            DJIMapkitLog.i(TAG, "init");
            Style style2 = this.mapboxMap.getStyle();
            if (style2 == null) break block1;
            Style it = style2;
            boolean bl = false;
            if (it.isFullyLoaded()) {
                this.setUpPolylineSource(it);
            }
        }
    }

    @NotNull
    public final DJIPolylineOptions getOptions() {
        return this.options;
    }

    private final GeoJsonSource getSource() {
        Lazy lazy = this.source$delegate;
        return (GeoJsonSource)lazy.getValue();
    }

    @NotNull
    public final LineLayer getPolylineLayer$android_sdk_v5_uxsdk_release() {
        Lazy lazy = this.polylineLayer$delegate;
        return (LineLayer)lazy.getValue();
    }

    @Override
    public void remove() {
        block1: {
            DJIMapkitLog.i(TAG, "remove");
            Style style2 = this.mapboxMap.getStyle();
            if (style2 == null) break block1;
            Style style3 = style2;
            boolean bl = false;
            if (!((Boolean)this.onRemovePolyline.invoke((Object)((int)this.options.getZIndex()), (Object)this)).booleanValue()) {
                DJIMapkitLog.e(TAG, "remove polyline " + this + " fail");
            }
            MapboxExtension.removeLayerAndLog(style3, (Layer)this.getPolylineLayer$android_sdk_v5_uxsdk_release());
            MapboxExtension.removeSourceAndLog(style3, (Source)this.getSource());
        }
    }

    @Override
    public void setWidth(float width) {
        PropertyValue[] propertyValueArray = new PropertyValue[]{PropertyFactory.lineWidth((Float)Float.valueOf(width / 5.0f))};
        this.getPolylineLayer$android_sdk_v5_uxsdk_release().withProperties(propertyValueArray);
    }

    @Override
    public float getWidth() {
        Object object = this.getPolylineLayer$android_sdk_v5_uxsdk_release().getLineWidth().getValue();
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.Float");
        return ((Float)object).floatValue() * 5.0f;
    }

    public void setPoints(@NotNull List<? extends DJILatLng> points) {
        LatLng it;
        Collection collection;
        Iterable $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(points, (String)"points");
        this.options.setPoints(points);
        Iterable $this$map$iv = points;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            DJILatLng dJILatLng = (DJILatLng)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(MapboxUtil.fromDJILatLng((DJILatLng)it));
        }
        $this$map$iv = (List)destination$iv$iv;
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (LatLng)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(Point.fromLngLat((double)it.getLongitude(), (double)it.getLatitude(), (double)it.getAltitude()));
        }
        List it2 = (List)destination$iv$iv;
        boolean bl = false;
        this.getSource().setGeoJson((Geometry)LineString.fromLngLats((List)it2));
    }

    @Override
    @NotNull
    public List<DJILatLng> getPoints() {
        List<DJILatLng> list = this.options.getPoints();
        Intrinsics.checkNotNullExpressionValue(list, (String)"getPoints(...)");
        return list;
    }

    @Override
    public void setColor(@ColorInt int color2) {
        PropertyValue[] propertyValueArray = new PropertyValue[]{PropertyFactory.lineColor((int)color2)};
        this.getPolylineLayer$android_sdk_v5_uxsdk_release().withProperties(propertyValueArray);
    }

    @Override
    @ColorInt
    public int getColor() {
        return this.getPolylineLayer$android_sdk_v5_uxsdk_release().getLineColorAsInt();
    }

    public final void clear$android_sdk_v5_uxsdk_release() {
        block0: {
            DJIMapkitLog.i(TAG, "clear");
            Style style2 = this.mapboxMap.getStyle();
            if (style2 == null) break block0;
            Style style3 = style2;
            boolean bl = false;
            MapboxExtension.removeLayerAndLog(style3, (Layer)this.getPolylineLayer$android_sdk_v5_uxsdk_release());
            MapboxExtension.removeSourceAndLog(style3, (Source)this.getSource());
        }
    }

    public final void restore$android_sdk_v5_uxsdk_release() {
        block0: {
            DJIMapkitLog.i(TAG, "restore");
            Style style2 = this.mapboxMap.getStyle();
            if (style2 == null) break block0;
            MapboxExtension.addSourceAndLog(style2, (Source)this.getSource());
        }
    }

    private final void setUpPolylineSource(Style style2) {
        MapboxExtension.addSourceAndLog(style2, (Source)this.getSource());
    }

    @Override
    public float getZIndex() {
        return this.options.getZIndex();
    }

    @Override
    public void setZIndex(float zIndex) {
        block0: {
            Style style2 = this.mapboxMap.getStyle();
            if (style2 == null) break block0;
            Style it = style2;
            boolean bl = false;
            this.onRemovePolyline.invoke((Object)((int)this.options.getZIndex()), (Object)this);
            this.options.zIndex(zIndex);
            this.onAddPolyline.invoke((Object)((int)this.options.getZIndex()), (Object)this);
        }
    }

    private static final GeoJsonSource source_delegate$lambda$3(MaplibrePolyline this$0) {
        LatLng it;
        Collection collection;
        Iterable $this$mapTo$iv$iv;
        List<DJILatLng> list = this$0.options.getPoints();
        Intrinsics.checkNotNullExpressionValue(list, (String)"getPoints(...)");
        Iterable $this$map$iv = list;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            DJILatLng dJILatLng = (DJILatLng)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it);
            collection.add(MapboxUtil.fromDJILatLng((DJILatLng)it));
        }
        $this$map$iv = (List)destination$iv$iv;
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (LatLng)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(Point.fromLngLat((double)it.getLongitude(), (double)it.getLatitude(), (double)it.getAltitude()));
        }
        List it2 = (List)destination$iv$iv;
        boolean bl = false;
        return new GeoJsonSource(MapboxUtil.getPolylineSourceIdAndIncrement(), (Geometry)LineString.fromLngLats((List)it2));
    }

    private static final LineLayer polylineLayer_delegate$lambda$4(MaplibrePolyline this$0) {
        PropertyValue[] propertyValueArray = new PropertyValue[]{PropertyFactory.lineJoin((String)"round"), PropertyFactory.lineWidth((Float)Float.valueOf(this$0.options.getWidth() / 5.0f)), PropertyFactory.lineColor((int)this$0.options.getColor())};
        PropertyValue[] propertyArray = propertyValueArray;
        return new LineLayer(MapboxUtil.getPolylineLayerIdAndIncrement(), this$0.getSource().getId()).withProperties(Arrays.copyOf(propertyArray, propertyArray.length));
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Ldji/v5/ux/mapkit/maplibre/annotations/MaplibrePolyline$Companion;", "", "<init>", "()V", "TAG", "", "android-sdk-v5-uxsdk_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

