/*
 * Decompiled with CFR 0.152.
 */
package dji.v5.ux.mapkit.maplibre.annotations;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.view.View;
import com.mapbox.geojson.Geometry;
import com.mapbox.geojson.Point;
import com.mapbox.mapboxsdk.geometry.LatLng;
import com.mapbox.mapboxsdk.maps.MapboxMap;
import com.mapbox.mapboxsdk.maps.Style;
import com.mapbox.mapboxsdk.style.layers.Layer;
import com.mapbox.mapboxsdk.style.layers.PropertyFactory;
import com.mapbox.mapboxsdk.style.layers.PropertyValue;
import com.mapbox.mapboxsdk.style.layers.SymbolLayer;
import com.mapbox.mapboxsdk.style.sources.GeoJsonSource;
import com.mapbox.mapboxsdk.style.sources.Source;
import dji.v5.ux.R;
import dji.v5.ux.mapkit.core.maps.DJIInfoWindow;
import dji.v5.ux.mapkit.core.maps.DJIMap;
import dji.v5.ux.mapkit.core.models.DJIBitmapDescriptor;
import dji.v5.ux.mapkit.core.models.DJIBitmapDescriptorFactory;
import dji.v5.ux.mapkit.core.models.DJILatLng;
import dji.v5.ux.mapkit.core.models.annotations.DJIMarker;
import dji.v5.ux.mapkit.core.models.annotations.DJIMarkerOptions;
import dji.v5.ux.mapkit.core.utils.DJIMapkitLog;
import dji.v5.ux.mapkit.maplibre.utils.MapboxExtension;
import dji.v5.ux.mapkit.maplibre.utils.MapboxUtil;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u008e\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0007\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u001b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000 j2\u00020\u0001:\u0001jBW\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00126\u0010\b\u001a2\u0012\u0013\u0012\u00110\n\u00a2\u0006\f\b\u000b\u0012\b\b\f\u0012\u0004\b\b(\r\u0012\u0013\u0012\u00110\u0000\u00a2\u0006\f\b\u000b\u0012\b\b\f\u0012\u0004\b\b(\u000e\u0012\u0004\u0012\u00020\u000f0\t\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u0010\u0010B\u001a\u00020C2\u0006\u0010D\u001a\u00020EH\u0016J\u0010\u0010F\u001a\u00020C2\u0006\u0010G\u001a\u00020.H\u0016J\u0012\u0010H\u001a\u00020C2\b\u0010I\u001a\u0004\u0018\u00010(H\u0016J\u0018\u0010J\u001a\u00020C2\u0006\u0010K\u001a\u00020.2\u0006\u0010L\u001a\u00020.H\u0016J\u0012\u0010M\u001a\u00020C2\b\u0010@\u001a\u0004\u0018\u00010!H\u0016J\n\u0010N\u001a\u0004\u0018\u00010!H\u0016J\b\u0010O\u001a\u00020EH\u0016J\u0010\u0010P\u001a\u00020C2\u0006\u0010Q\u001a\u00020\u000fH\u0016J\b\u0010R\u001a\u00020\u000fH\u0016J\b\u0010S\u001a\u00020CH\u0016J\b\u0010T\u001a\u00020CH\u0016J\b\u0010U\u001a\u00020\u000fH\u0016J\b\u0010V\u001a\u00020CH\u0016J\u0010\u0010W\u001a\u00020C2\u0006\u0010X\u001a\u00020\u000fH\u0016J\b\u0010Y\u001a\u00020\u000fH\u0016J\r\u0010Z\u001a\u00020CH\u0000\u00a2\u0006\u0002\b[J\r\u0010\\\u001a\u00020CH\u0000\u00a2\u0006\u0002\b]J\b\u0010^\u001a\u00020CH\u0002J\b\u0010_\u001a\u00020CH\u0002J\u0010\u0010`\u001a\u00020a2\u0006\u0010=\u001a\u00020bH\u0002J\u001a\u0010c\u001a\u00020C2\u0006\u0010d\u001a\u00020e2\b\u0010f\u001a\u0004\u0018\u00010(H\u0002J\u0010\u0010g\u001a\u00020C2\u0006\u0010d\u001a\u00020eH\u0002J\u0012\u0010h\u001a\u00020C2\b\u0010=\u001a\u0004\u0018\u00010<H\u0002J\b\u0010i\u001a\u00020!H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R>\u0010\b\u001a2\u0012\u0013\u0012\u00110\n\u00a2\u0006\f\b\u000b\u0012\b\b\f\u0012\u0004\b\b(\r\u0012\u0013\u0012\u00110\u0000\u00a2\u0006\f\b\u000b\u0012\b\b\f\u0012\u0004\b\b(\u000e\u0012\u0004\u0012\u00020\u000f0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0012\u001a\u00020\u00138BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0016\u0010\u0017\u001a\u0004\b\u0014\u0010\u0015R\u001b\u0010\u0018\u001a\u00020\u00198@X\u0080\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001c\u0010\u0017\u001a\u0004\b\u001a\u0010\u001bR\u001b\u0010\u001d\u001a\u00020\u00198BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001f\u0010\u0017\u001a\u0004\b\u001e\u0010\u001bR\u0014\u0010 \u001a\u00020!X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010#R\u000e\u0010$\u001a\u00020!X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010%\u001a\u00020!X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010#R\u0018\u0010'\u001a\n )*\u0004\u0018\u00010(0(X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010*R\u000e\u0010+\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010,\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010-\u001a\u00020.X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010/\u001a\u00020!8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b1\u0010\u0017\u001a\u0004\b0\u0010#R\u001b\u00102\u001a\u00020!8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b4\u0010\u0017\u001a\u0004\b3\u0010#R\u001c\u00105\u001a\u0004\u0018\u000106X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b7\u00108\"\u0004\b9\u0010:R\"\u0010=\u001a\u0004\u0018\u00010<2\b\u0010;\u001a\u0004\u0018\u00010<@BX\u0082\u000e\u00a2\u0006\b\n\u0000\"\u0004\b>\u0010?R\u0010\u0010@\u001a\u0004\u0018\u00010!X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010A\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006k"}, d2={"Ldji/v5/ux/mapkit/maplibre/annotations/MaplibreMarker;", "Ldji/v5/ux/mapkit/core/models/annotations/DJIMarker;", "context", "Landroid/content/Context;", "mapboxMap", "Lcom/mapbox/mapboxsdk/maps/MapboxMap;", "options", "Ldji/v5/ux/mapkit/core/models/annotations/DJIMarkerOptions;", "onRemoveMarker", "Lkotlin/Function2;", "", "Lkotlin/ParameterName;", "name", "zindex", "marker", "", "<init>", "(Landroid/content/Context;Lcom/mapbox/mapboxsdk/maps/MapboxMap;Ldji/v5/ux/mapkit/core/models/annotations/DJIMarkerOptions;Lkotlin/jvm/functions/Function2;)V", "source", "Lcom/mapbox/mapboxsdk/style/sources/GeoJsonSource;", "getSource", "()Lcom/mapbox/mapboxsdk/style/sources/GeoJsonSource;", "source$delegate", "Lkotlin/Lazy;", "markerLayer", "Lcom/mapbox/mapboxsdk/style/layers/SymbolLayer;", "getMarkerLayer$android_sdk_v5_uxsdk_release", "()Lcom/mapbox/mapboxsdk/style/layers/SymbolLayer;", "markerLayer$delegate", "infoWindowLayer", "getInfoWindowLayer", "infoWindowLayer$delegate", "sourceFeatureId", "", "getSourceFeatureId$android_sdk_v5_uxsdk_release", "()Ljava/lang/String;", "iconId", "markerLayerId", "getMarkerLayerId$android_sdk_v5_uxsdk_release", "descriptor", "Ldji/v5/ux/mapkit/core/models/DJIBitmapDescriptor;", "kotlin.jvm.PlatformType", "Ldji/v5/ux/mapkit/core/models/DJIBitmapDescriptor;", "markerIconWidth", "markerIconHeight", "pixelRatio", "", "infoWindowIconId", "getInfoWindowIconId", "infoWindowIconId$delegate", "infoWindowLayerId", "getInfoWindowLayerId", "infoWindowLayerId$delegate", "infoWindowAdapter", "Ldji/v5/ux/mapkit/core/maps/DJIMap$InfoWindowAdapter;", "getInfoWindowAdapter$android_sdk_v5_uxsdk_release", "()Ldji/v5/ux/mapkit/core/maps/DJIMap$InfoWindowAdapter;", "setInfoWindowAdapter$android_sdk_v5_uxsdk_release", "(Ldji/v5/ux/mapkit/core/maps/DJIMap$InfoWindowAdapter;)V", "value", "Ldji/v5/ux/mapkit/core/maps/DJIInfoWindow;", "infoWindow", "setInfoWindow", "(Ldji/v5/ux/mapkit/core/maps/DJIInfoWindow;)V", "title", "draggable", "setPosition", "", "latLng", "Ldji/v5/ux/mapkit/core/models/DJILatLng;", "setRotation", "rotation", "setIcon", "bitmap", "setAnchor", "u", "v", "setTitle", "getTitle", "getPosition", "setVisible", "visible", "isVisible", "showInfoWindow", "hideInfoWindow", "isInfoWindowShown", "remove", "setDraggable", "b", "isDraggable", "restore", "restore$android_sdk_v5_uxsdk_release", "clearMarker", "clearMarker$android_sdk_v5_uxsdk_release", "createInfoWindowLayer", "destroyInfoWindowLayer", "generateInfoWindowBitmap", "Landroid/graphics/Bitmap;", "Landroid/view/View;", "setUpMarkerIcon", "style", "Lcom/mapbox/mapboxsdk/maps/Style;", "icon", "setUpSource", "updateInfoWindow", "toString", "Companion", "android-sdk-v5-uxsdk_release"})
@SourceDebugExtension(value={"SMAP\nMaplibreMarker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MaplibreMarker.kt\ndji/v5/ux/mapkit/maplibre/annotations/MaplibreMarker\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,265:1\n1#2:266\n*E\n"})
public final class MaplibreMarker
extends DJIMarker {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Context context;
    @NotNull
    private final MapboxMap mapboxMap;
    @NotNull
    private final DJIMarkerOptions options;
    @NotNull
    private final Function2<Integer, MaplibreMarker, Boolean> onRemoveMarker;
    @NotNull
    private final Lazy source$delegate;
    @NotNull
    private final Lazy markerLayer$delegate;
    @NotNull
    private final Lazy infoWindowLayer$delegate;
    @NotNull
    private final String sourceFeatureId;
    @NotNull
    private final String iconId;
    @NotNull
    private final String markerLayerId;
    private DJIBitmapDescriptor descriptor;
    private int markerIconWidth;
    private int markerIconHeight;
    private final float pixelRatio;
    @NotNull
    private final Lazy infoWindowIconId$delegate;
    @NotNull
    private final Lazy infoWindowLayerId$delegate;
    @Nullable
    private DJIMap.InfoWindowAdapter infoWindowAdapter;
    @Nullable
    private DJIInfoWindow infoWindow;
    @Nullable
    private String title;
    private boolean draggable;
    @NotNull
    private static final String TAG = "MaplibreMarker";

    public MaplibreMarker(@NotNull Context context, @NotNull MapboxMap mapboxMap, @NotNull DJIMarkerOptions options, @NotNull Function2<? super Integer, ? super MaplibreMarker, Boolean> onRemoveMarker) {
        block1: {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)mapboxMap, (String)"mapboxMap");
            Intrinsics.checkNotNullParameter((Object)options, (String)"options");
            Intrinsics.checkNotNullParameter(onRemoveMarker, (String)"onRemoveMarker");
            this.context = context;
            this.mapboxMap = mapboxMap;
            this.options = options;
            this.onRemoveMarker = onRemoveMarker;
            this.source$delegate = LazyKt.lazy(() -> MaplibreMarker.source_delegate$lambda$0(this));
            this.markerLayer$delegate = LazyKt.lazy(() -> MaplibreMarker.markerLayer_delegate$lambda$1(this));
            this.infoWindowLayer$delegate = LazyKt.lazy(() -> MaplibreMarker.infoWindowLayer_delegate$lambda$2(this));
            this.sourceFeatureId = MapboxUtil.getSourceFeatureIdAndIncrement();
            this.iconId = MapboxUtil.getMarkerIconIdAndIncrement();
            this.markerLayerId = MapboxUtil.getMarkerLayerIdAndIncrement();
            this.descriptor = this.options.getIcon();
            this.pixelRatio = this.context.getResources().getDisplayMetrics().density;
            this.infoWindowIconId$delegate = LazyKt.lazy(() -> MaplibreMarker.infoWindowIconId_delegate$lambda$3(this));
            this.infoWindowLayerId$delegate = LazyKt.lazy(() -> MaplibreMarker.infoWindowLayerId_delegate$lambda$4(this));
            this.title = this.options.getTitle();
            this.draggable = this.options.getDraggable();
            DJIMapkitLog.i(TAG, "init");
            Style style2 = this.mapboxMap.getStyle();
            if (style2 == null) break block1;
            Style it = style2;
            boolean bl = false;
            if (it.isFullyLoaded()) {
                this.setUpSource(it);
                this.setUpMarkerIcon(it, this.descriptor);
            }
        }
    }

    private final GeoJsonSource getSource() {
        Lazy lazy = this.source$delegate;
        return (GeoJsonSource)lazy.getValue();
    }

    @NotNull
    public final SymbolLayer getMarkerLayer$android_sdk_v5_uxsdk_release() {
        Lazy lazy = this.markerLayer$delegate;
        return (SymbolLayer)lazy.getValue();
    }

    private final SymbolLayer getInfoWindowLayer() {
        Lazy lazy = this.infoWindowLayer$delegate;
        return (SymbolLayer)lazy.getValue();
    }

    @NotNull
    public final String getSourceFeatureId$android_sdk_v5_uxsdk_release() {
        return this.sourceFeatureId;
    }

    @NotNull
    public final String getMarkerLayerId$android_sdk_v5_uxsdk_release() {
        return this.markerLayerId;
    }

    private final String getInfoWindowIconId() {
        Lazy lazy = this.infoWindowIconId$delegate;
        return (String)lazy.getValue();
    }

    private final String getInfoWindowLayerId() {
        Lazy lazy = this.infoWindowLayerId$delegate;
        return (String)lazy.getValue();
    }

    @Nullable
    public final DJIMap.InfoWindowAdapter getInfoWindowAdapter$android_sdk_v5_uxsdk_release() {
        return this.infoWindowAdapter;
    }

    public final void setInfoWindowAdapter$android_sdk_v5_uxsdk_release(@Nullable DJIMap.InfoWindowAdapter infoWindowAdapter) {
        this.infoWindowAdapter = infoWindowAdapter;
    }

    /*
     * WARNING - void declaration
     */
    private final void setInfoWindow(DJIInfoWindow value) {
        DJIInfoWindow dJIInfoWindow;
        MaplibreMarker maplibreMarker = this;
        DJIInfoWindow dJIInfoWindow2 = value;
        if (dJIInfoWindow2 != null) {
            void $this$_set_infoWindow__u24lambda_u246;
            DJIInfoWindow dJIInfoWindow3;
            DJIInfoWindow dJIInfoWindow4 = dJIInfoWindow3 = dJIInfoWindow2;
            MaplibreMarker maplibreMarker2 = maplibreMarker;
            boolean bl = false;
            this.updateInfoWindow((DJIInfoWindow)$this$_set_infoWindow__u24lambda_u246);
            $this$_set_infoWindow__u24lambda_u246.setOnViewChangedListener((Function0<Unit>)((Function0)() -> MaplibreMarker._set_infoWindow_$lambda$6$lambda$5(this, (DJIInfoWindow)$this$_set_infoWindow__u24lambda_u246)));
            maplibreMarker = maplibreMarker2;
            dJIInfoWindow = dJIInfoWindow3;
        } else {
            dJIInfoWindow = null;
        }
        maplibreMarker.infoWindow = dJIInfoWindow;
    }

    @Override
    public void setPosition(@NotNull DJILatLng latLng) {
        Intrinsics.checkNotNullParameter((Object)latLng, (String)"latLng");
        this.options.position(latLng);
        LatLng it = MapboxUtil.fromDJILatLng(latLng);
        boolean bl = false;
        this.getSource().setGeoJson((Geometry)Point.fromLngLat((double)it.getLongitude(), (double)it.getLatitude()));
    }

    @Override
    public void setRotation(float rotation) {
        PropertyValue[] propertyValueArray = new PropertyValue[]{PropertyFactory.iconRotate((Float)Float.valueOf(rotation))};
        this.getMarkerLayer$android_sdk_v5_uxsdk_release().withProperties(propertyValueArray);
    }

    @Override
    public void setIcon(@Nullable DJIBitmapDescriptor bitmap) {
        block1: {
            Style style2 = this.mapboxMap.getStyle();
            if (style2 == null) break block1;
            Style it = style2;
            boolean bl = false;
            if (it.isFullyLoaded()) {
                this.setUpMarkerIcon(it, bitmap);
            }
        }
    }

    @Override
    public void setAnchor(float u, float v) {
        PropertyValue[] propertyValueArray = new PropertyValue[1];
        Float[] floatArray = new Float[]{Float.valueOf(u), Float.valueOf(v)};
        propertyValueArray[0] = PropertyFactory.iconOffset((Float[])floatArray);
        this.getMarkerLayer$android_sdk_v5_uxsdk_release().withProperties(propertyValueArray);
    }

    @Override
    public void setTitle(@Nullable String title) {
        this.title = title;
    }

    @Override
    @Nullable
    public String getTitle() {
        return this.title;
    }

    @Override
    @NotNull
    public DJILatLng getPosition() {
        DJILatLng dJILatLng = this.options.getPosition();
        Intrinsics.checkNotNullExpressionValue((Object)dJILatLng, (String)"getPosition(...)");
        return dJILatLng;
    }

    @Override
    public void setVisible(boolean visible) {
        if (visible) {
            PropertyValue[] propertyValueArray = new PropertyValue[]{PropertyFactory.visibility((String)"visible")};
            v0 = this.getMarkerLayer$android_sdk_v5_uxsdk_release().withProperties(propertyValueArray);
        } else {
            PropertyValue[] propertyValueArray = new PropertyValue[]{PropertyFactory.visibility((String)"none")};
            v0 = this.getMarkerLayer$android_sdk_v5_uxsdk_release().withProperties(propertyValueArray);
        }
    }

    @Override
    public boolean isVisible() {
        return Intrinsics.areEqual((Object)this.getMarkerLayer$android_sdk_v5_uxsdk_release().getVisibility().getValue(), (Object)"visible");
    }

    @Override
    public void showInfoWindow() {
        block1: {
            DJIMap.InfoWindowAdapter infoWindowAdapter = this.infoWindowAdapter;
            DJIMapkitLog.i(TAG, "show info window " + this.iconId + ", is shown " + this.isInfoWindowShown() + ", info window " + (infoWindowAdapter != null ? infoWindowAdapter.getInfoWindow(this) : null));
            if (this.isInfoWindowShown()) {
                return;
            }
            DJIMap.InfoWindowAdapter infoWindowAdapter2 = this.infoWindowAdapter;
            if (infoWindowAdapter2 == null || (infoWindowAdapter2 = infoWindowAdapter2.getInfoWindow(this)) == null) break block1;
            DJIMap.InfoWindowAdapter it = infoWindowAdapter2;
            boolean bl = false;
            this.setInfoWindow((DJIInfoWindow)((Object)it));
            ((DJIInfoWindow)((Object)it)).onCreate();
            this.createInfoWindowLayer();
        }
    }

    @Override
    public void hideInfoWindow() {
        block1: {
            DJIInfoWindow dJIInfoWindow = this.infoWindow;
            if (dJIInfoWindow == null) break block1;
            DJIInfoWindow it = dJIInfoWindow;
            boolean bl = false;
            this.setInfoWindow(null);
            this.destroyInfoWindowLayer();
            Style style2 = this.mapboxMap.getStyle();
            if (style2 != null) {
                style2.removeImage(this.getInfoWindowIconId());
            }
            it.onDestroy();
        }
    }

    @Override
    public boolean isInfoWindowShown() {
        return this.infoWindow != null;
    }

    @Override
    public void remove() {
        block1: {
            DJIMapkitLog.i(TAG, "remove this marker");
            this.hideInfoWindow();
            Style style2 = this.mapboxMap.getStyle();
            if (style2 == null) break block1;
            Style it = style2;
            boolean bl = false;
            if (!((Boolean)this.onRemoveMarker.invoke((Object)this.options.getZIndex(), (Object)this)).booleanValue()) {
                DJIMapkitLog.e(TAG, "remove marker " + this + " fail");
            }
            it.removeImage(this.iconId);
            MapboxExtension.removeLayerAndLog(it, (Layer)this.getMarkerLayer$android_sdk_v5_uxsdk_release());
            MapboxExtension.removeSourceAndLog(it, (Source)this.getSource());
        }
    }

    @Override
    public void setDraggable(boolean b) {
        this.draggable = b;
    }

    @Override
    public boolean isDraggable() {
        return this.draggable;
    }

    public final void restore$android_sdk_v5_uxsdk_release() {
        block1: {
            DJIInfoWindow it;
            DJIMapkitLog.i(TAG, "restore");
            DJIInfoWindow dJIInfoWindow = this.infoWindow;
            if (dJIInfoWindow != null) {
                it = dJIInfoWindow;
                boolean bl = false;
                DJIMapkitLog.i(TAG, "restore info window " + this.getInfoWindowLayerId());
                this.updateInfoWindow(it);
                this.createInfoWindowLayer();
            }
            Style style2 = this.mapboxMap.getStyle();
            if (style2 == null) break block1;
            it = style2;
            boolean bl = false;
            this.setUpMarkerIcon((Style)it, this.descriptor);
            MapboxExtension.addSourceAndLog((Style)it, (Source)this.getSource());
        }
    }

    public final void clearMarker$android_sdk_v5_uxsdk_release() {
        block2: {
            DJIInfoWindow it;
            DJIInfoWindow dJIInfoWindow = this.infoWindow;
            if (dJIInfoWindow != null) {
                it = dJIInfoWindow;
                boolean bl = false;
                DJIMapkitLog.i(TAG, "clear info window " + this.getInfoWindowLayerId());
                this.destroyInfoWindowLayer();
                Style style2 = this.mapboxMap.getStyle();
                if (style2 != null) {
                    style2.removeImage(this.getInfoWindowIconId());
                }
            }
            Style style3 = this.mapboxMap.getStyle();
            if (style3 == null) break block2;
            it = style3;
            boolean bl = false;
            DJIMapkitLog.i(TAG, "clear marker");
            MapboxExtension.removeLayerAndLog((Style)it, (Layer)this.getMarkerLayer$android_sdk_v5_uxsdk_release());
            MapboxExtension.removeSourceAndLog((Style)it, (Source)this.getSource());
            it.removeImage(this.iconId);
        }
    }

    private final void createInfoWindowLayer() {
        block0: {
            Style style2 = this.mapboxMap.getStyle();
            if (style2 == null) break block0;
            MapboxExtension.addLayerAndLog(style2, (Layer)this.getInfoWindowLayer());
        }
    }

    private final void destroyInfoWindowLayer() {
        block0: {
            Style style2 = this.mapboxMap.getStyle();
            if (style2 == null) break block0;
            MapboxExtension.removeLayerAndLog(style2, (Layer)this.getInfoWindowLayer());
        }
    }

    private final Bitmap generateInfoWindowBitmap(View infoWindow) {
        Bitmap bitmap;
        int it = View.MeasureSpec.makeMeasureSpec((int)0, (int)0);
        boolean bl = false;
        infoWindow.measure(it, it);
        View $this$generateInfoWindowBitmap_u24lambda_u2419 = infoWindow;
        boolean bl2 = false;
        $this$generateInfoWindowBitmap_u24lambda_u2419.layout(0, 0, $this$generateInfoWindowBitmap_u24lambda_u2419.getMeasuredWidth(), $this$generateInfoWindowBitmap_u24lambda_u2419.getMeasuredHeight());
        Bitmap $this$generateInfoWindowBitmap_u24lambda_u2419_u24lambda_u2418 = bitmap = Bitmap.createBitmap((int)$this$generateInfoWindowBitmap_u24lambda_u2419.getMeasuredWidth(), (int)$this$generateInfoWindowBitmap_u24lambda_u2419.getMeasuredHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
        boolean bl3 = false;
        $this$generateInfoWindowBitmap_u24lambda_u2419_u24lambda_u2418.eraseColor(0);
        Bitmap bitmap2 = bitmap;
        Intrinsics.checkNotNullExpressionValue((Object)bitmap2, (String)"apply(...)");
        Bitmap bitmap3 = bitmap2;
        $this$generateInfoWindowBitmap_u24lambda_u2419.draw(new Canvas(bitmap3));
        return bitmap3;
    }

    private final void setUpMarkerIcon(Style style2, DJIBitmapDescriptor icon) {
        block1: {
            this.descriptor = icon;
            if (this.descriptor == null) {
                this.descriptor = DJIBitmapDescriptorFactory.fromResource(R.drawable.uxsdk_ic_bird);
            }
            Bitmap bitmap = MapboxUtil.fromDJIBitmapDescriptor(this.context, this.descriptor);
            if (bitmap == null) break block1;
            Bitmap bitmap2 = bitmap;
            boolean bl = false;
            this.markerIconWidth = bitmap2.getWidth();
            this.markerIconHeight = bitmap2.getHeight();
            style2.removeImage(this.iconId);
            style2.addImage(this.iconId, bitmap2);
        }
    }

    private final void setUpSource(Style style2) {
        MapboxExtension.addSourceAndLog(style2, (Source)this.getSource());
    }

    private final void updateInfoWindow(DJIInfoWindow infoWindow) {
        block2: {
            DJIInfoWindow dJIInfoWindow = infoWindow;
            if (dJIInfoWindow == null) break block2;
            DJIInfoWindow it = dJIInfoWindow;
            boolean bl = false;
            Bitmap bitmap = this.generateInfoWindowBitmap((View)it);
            Style style2 = this.mapboxMap.getStyle();
            if (style2 != null) {
                Style $this$updateInfoWindow_u24lambda_u2422_u24lambda_u2421 = style2;
                boolean bl2 = false;
                if ($this$updateInfoWindow_u24lambda_u2422_u24lambda_u2421.isFullyLoaded()) {
                    $this$updateInfoWindow_u24lambda_u2422_u24lambda_u2421.removeImage(this.getInfoWindowIconId());
                    $this$updateInfoWindow_u24lambda_u2422_u24lambda_u2421.addImage(this.getInfoWindowIconId(), bitmap);
                }
            }
        }
    }

    @NotNull
    public String toString() {
        String result = "MaplibreMarker { iconid = " + this.iconId + ", markerLayerId = " + this.getMarkerLayer$android_sdk_v5_uxsdk_release().getId() + ", markerSourceId = " + this.getSource().getId() + "}";
        if (this.isInfoWindowShown()) {
            result = result + ", info window layer id = " + this.getInfoWindowLayer().getId();
        }
        return result;
    }

    private static final GeoJsonSource source_delegate$lambda$0(MaplibreMarker this$0) {
        DJIMapkitLog.i(TAG, "init");
        DJILatLng dJILatLng = this$0.options.getPosition();
        Intrinsics.checkNotNullExpressionValue((Object)dJILatLng, (String)"getPosition(...)");
        LatLng latLng = MapboxUtil.fromDJILatLng(dJILatLng);
        return new GeoJsonSource(MapboxUtil.getMarkerSourceIdAndIncrement(), (Geometry)Point.fromLngLat((double)latLng.getLongitude(), (double)latLng.getLatitude(), (double)latLng.getAltitude()));
    }

    private static final SymbolLayer markerLayer_delegate$lambda$1(MaplibreMarker this$0) {
        PropertyValue[] propertyValueArray = new PropertyValue[]{PropertyFactory.iconImage((String)this$0.iconId), PropertyFactory.iconAllowOverlap((Boolean)true), PropertyFactory.iconIgnorePlacement((Boolean)true), PropertyFactory.iconRotate((Float)Float.valueOf(this$0.options.getRotation()))};
        SymbolLayer symbolLayer = new SymbolLayer(this$0.markerLayerId, this$0.getSource().getId()).withProperties(propertyValueArray);
        Intrinsics.checkNotNullExpressionValue((Object)symbolLayer, (String)"withProperties(...)");
        return symbolLayer;
    }

    private static final SymbolLayer infoWindowLayer_delegate$lambda$2(MaplibreMarker this$0) {
        PropertyValue[] propertyValueArray = new PropertyValue[4];
        propertyValueArray[0] = PropertyFactory.iconImage((String)this$0.getInfoWindowIconId());
        propertyValueArray[1] = PropertyFactory.iconAnchor((String)"bottom");
        propertyValueArray[2] = PropertyFactory.iconAllowOverlap((Boolean)true);
        Float[] floatArray = new Float[]{Float.valueOf(0.0f), Float.valueOf((float)(-this$0.markerIconHeight) / 2.0f / this$0.pixelRatio)};
        propertyValueArray[3] = PropertyFactory.iconOffset((Float[])floatArray);
        SymbolLayer symbolLayer = new SymbolLayer(this$0.getInfoWindowLayerId(), this$0.getSource().getId()).withProperties(propertyValueArray);
        Intrinsics.checkNotNullExpressionValue((Object)symbolLayer, (String)"withProperties(...)");
        return symbolLayer;
    }

    private static final String infoWindowIconId_delegate$lambda$3(MaplibreMarker this$0) {
        return MapboxUtil.getInfoWindowIconId(this$0.iconId);
    }

    private static final String infoWindowLayerId_delegate$lambda$4(MaplibreMarker this$0) {
        return MapboxUtil.getInfoWindowLayerId(this$0.markerLayerId);
    }

    private static final Unit _set_infoWindow_$lambda$6$lambda$5(MaplibreMarker this$0, DJIInfoWindow $this_apply) {
        this$0.updateInfoWindow($this_apply);
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Ldji/v5/ux/mapkit/maplibre/annotations/MaplibreMarker$Companion;", "", "<init>", "()V", "TAG", "", "android-sdk-v5-uxsdk_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

