/*
 * Decompiled with CFR 0.152.
 */
package dji.v5.ux.mapkit.maplibre.annotations;

import com.mapbox.geojson.Geometry;
import com.mapbox.geojson.Point;
import com.mapbox.mapboxsdk.maps.MapboxMap;
import com.mapbox.mapboxsdk.style.layers.CircleLayer;
import com.mapbox.mapboxsdk.style.layers.Layer;
import com.mapbox.mapboxsdk.style.layers.PropertyFactory;
import com.mapbox.mapboxsdk.style.layers.PropertyValue;
import com.mapbox.mapboxsdk.style.sources.GeoJsonSource;
import com.mapbox.mapboxsdk.style.sources.Source;
import dji.v5.ux.mapkit.core.models.DJILatLng;
import dji.v5.ux.mapkit.core.models.annotations.DJICircle;
import dji.v5.ux.mapkit.core.models.annotations.DJICircleOptions;
import dji.v5.ux.mapkit.maplibre.map.MaplibreMapDelegate;

public class MMarkerCircle
implements DJICircle {
    private MapboxMap mapboxMap;
    private CircleLayer markerCircleLayer;
    private GeoJsonSource source;
    private MaplibreMapDelegate maplibreMapDelegate;
    private DJICircleOptions options;
    private String sourceId;
    private String layerId;

    private MMarkerCircle() {
    }

    public MMarkerCircle(MaplibreMapDelegate maplibreMapDelegate, MapboxMap mapboxMap, CircleLayer circleMarkerLayer, GeoJsonSource source, DJICircleOptions options) {
        this.maplibreMapDelegate = maplibreMapDelegate;
        this.mapboxMap = mapboxMap;
        this.markerCircleLayer = circleMarkerLayer;
        this.source = source;
        this.sourceId = source.getId();
        this.layerId = circleMarkerLayer.getId();
        this.options = options;
    }

    public void updateSourceLayer() {
        this.source = new GeoJsonSource(this.sourceId);
        this.setCircle(this.options.getCenter(), this.options.getRadius());
        this.mapboxMap.getStyle().addSource((Source)this.source);
        this.markerCircleLayer = new CircleLayer(this.layerId, this.sourceId);
        this.setFillColor(this.options.getFillColor());
        this.setStrokeColor(this.options.getStrokeColor());
        this.maplibreMapDelegate.updateLayerByZIndex((int)this.options.getZIndex(), (Layer)this.markerCircleLayer);
    }

    @Override
    public void remove() {
        this.maplibreMapDelegate.onMarkerCircleRemove(this);
    }

    @Override
    public void setCircle(DJILatLng center, Double radius) {
        if (this.maplibreMapDelegate.isStoppingWorld()) {
            return;
        }
        this.options.center(center);
        this.options.radius(radius);
        Point point = Point.fromLngLat((double)center.getLongitude(), (double)center.getLatitude(), (double)center.getAltitude());
        this.source.setGeoJson((Geometry)point);
        this.markerCircleLayer.setProperties(new PropertyValue[]{PropertyFactory.circleRadius((Float)Float.valueOf(radius.floatValue()))});
    }

    @Override
    public void setStrokeWidth(float strokeWidth) {
    }

    @Override
    public float getStrokeWidth() {
        return 0.0f;
    }

    @Override
    public void setVisible(boolean visible) {
        if (this.maplibreMapDelegate.isStoppingWorld()) {
            return;
        }
        if (visible) {
            this.markerCircleLayer.setProperties(new PropertyValue[]{PropertyFactory.visibility((String)"visible")});
        } else {
            this.markerCircleLayer.setProperties(new PropertyValue[]{PropertyFactory.visibility((String)"none")});
        }
    }

    @Override
    public boolean isVisible() {
        boolean visible = ((String)this.markerCircleLayer.getVisibility().value).equals("visible");
        return visible;
    }

    @Override
    public void setCenter(DJILatLng center) {
        this.options.center(center);
        this.setCircle(center, this.getRadius());
    }

    @Override
    public DJILatLng getCenter() {
        return this.options.getCenter();
    }

    @Override
    public void setRadius(double radius) {
        this.options.radius(radius);
        this.setCircle(this.getCenter(), radius);
    }

    @Override
    public double getRadius() {
        return this.options.getRadius();
    }

    @Override
    public void setFillColor(int color2) {
        if (this.maplibreMapDelegate.isStoppingWorld()) {
            return;
        }
        this.options.fillColor(color2);
        this.markerCircleLayer.setProperties(new PropertyValue[]{PropertyFactory.circleColor((int)color2)});
    }

    @Override
    public int getFillColor() {
        return this.markerCircleLayer.getCircleColorAsInt();
    }

    @Override
    public void setStrokeColor(int color2) {
        if (this.maplibreMapDelegate.isStoppingWorld()) {
            return;
        }
        this.options.strokeColor(color2);
        this.markerCircleLayer.setProperties(new PropertyValue[]{PropertyFactory.circleStrokeColor((int)color2)});
    }

    @Override
    public int getStrokeColor() {
        return this.markerCircleLayer.getCircleStrokeColorAsInt();
    }

    @Override
    public void setZIndex(float zIndex) {
        if (this.maplibreMapDelegate.isStoppingWorld()) {
            return;
        }
        this.options.zIndex(zIndex);
        this.maplibreMapDelegate.updateLayerByZIndex((int)zIndex, (Layer)this.markerCircleLayer);
    }

    @Override
    public float getZIndex() {
        return this.options.getZIndex();
    }

    public String getSourceID() {
        return this.sourceId;
    }

    public String getLayerId() {
        return this.layerId;
    }
}

