/*
 * Decompiled with CFR 0.152.
 */
package dji.v5.ux.core.base;

import android.content.Context;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.util.SparseLongArray;
import android.view.ViewGroup;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.constraintlayout.widget.ConstraintLayout;
import androidx.constraintlayout.widget.Group;
import androidx.core.content.ContextCompat;
import dji.sdk.keyvalue.key.DJIActionKeyInfo;
import dji.sdk.keyvalue.key.DJIKeyInfo;
import dji.sdk.keyvalue.key.FlightControllerKey;
import dji.sdk.keyvalue.key.KeyTools;
import dji.sdk.keyvalue.key.ProductKey;
import dji.sdk.keyvalue.value.common.EmptyMsg;
import dji.sdk.keyvalue.value.flightcontroller.CompassSensorState;
import dji.sdk.keyvalue.value.flightcontroller.CompassState;
import dji.sdk.keyvalue.value.flightcontroller.RedundancySensorUsedStateMsg;
import dji.sdk.keyvalue.value.product.ProductType;
import dji.v5.common.callback.CommonCallbacks;
import dji.v5.common.error.IDJIError;
import dji.v5.manager.KeyManager;
import dji.v5.manager.aircraft.simulator.SimulatorManager;
import dji.v5.ux.R;
import dji.v5.ux.core.base.CompassCalibrationDialog;
import dji.v5.ux.core.base.ProgressStatusWidget;
import dji.v5.ux.core.util.ViewUtil;
import java.util.ArrayList;
import java.util.List;

public class CompassStatusWidget
extends ConstraintLayout {
    private static final int THREE_COMPASS = 3;
    private int[] mCompassStasActionStrIds = new int[]{R.string.uxsdk_setting_ui_redundancy_sensor_compass_stat_action_0, R.string.uxsdk_setting_ui_redundancy_sensor_compass_stat_empty, R.string.uxsdk_setting_ui_redundancy_sensor_compass_stat_empty, R.string.uxsdk_setting_ui_redundancy_sensor_compass_stat_action_3, R.string.uxsdk_setting_ui_redundancy_sensor_compass_stat_action_4, R.string.uxsdk_setting_ui_redundancy_sensor_compass_stat_empty, R.string.uxsdk_setting_ui_redundancy_sensor_compass_stat_empty, R.string.uxsdk_setting_ui_redundancy_sensor_compass_stat_action_7, R.string.uxsdk_setting_ui_redundancy_sensor_compass_stat_action_8, R.string.uxsdk_setting_ui_redundancy_sensor_compass_stat_action_9};
    Group mSettingUiFlycCompassLy2;
    Group mSettingUiFlycCompassLy3;
    List<TextView> mSettingUiFlycTitles = new ArrayList<TextView>();
    List<ProgressStatusWidget> mSettingUiFlyValues = new ArrayList<ProgressStatusWidget>();
    List<TextView> mSettingUiFlyDescs = new ArrayList<TextView>();
    private boolean mAreMotorOn;
    private boolean mSimulatorStarted;
    private List<CompassState> mCompassStateList;
    private RedundancySensorUsedStateMsg mSensorUsedState;
    private CompassCalibrationDialog mCalibrationDialog;
    private SparseLongArray sClickTimes = new SparseLongArray();

    private void initView() {
        this.mSettingUiFlycCompassLy2 = (Group)this.findViewById(R.id.setting_ui_flyc_compass_ly2);
        this.mSettingUiFlycCompassLy3 = (Group)this.findViewById(R.id.setting_ui_flyc_compass_ly3);
        this.mSettingUiFlycTitles.add((TextView)this.findViewById(R.id.setting_ui_flyc_compass_1_txt));
        this.mSettingUiFlycTitles.add((TextView)this.findViewById(R.id.setting_ui_flyc_compass_2_txt));
        this.mSettingUiFlycTitles.add((TextView)this.findViewById(R.id.setting_ui_flyc_compass_3_txt));
        this.mSettingUiFlyValues.add((ProgressStatusWidget)this.findViewById(R.id.setting_ui_flyc_compass_1_progress));
        this.mSettingUiFlyValues.add((ProgressStatusWidget)this.findViewById(R.id.setting_ui_flyc_compass_2_progress));
        this.mSettingUiFlyValues.add((ProgressStatusWidget)this.findViewById(R.id.setting_ui_flyc_compass_3_progress));
        this.mSettingUiFlyDescs.add((TextView)this.findViewById(R.id.setting_ui_flyc_compass_1_desc));
        this.mSettingUiFlyDescs.add((TextView)this.findViewById(R.id.setting_ui_flyc_compass_2_desc));
        this.mSettingUiFlyDescs.add((TextView)this.findViewById(R.id.setting_ui_flyc_compass_3_desc));
        this.findViewById(R.id.setting_menu_compass_calibrate).setOnClickListener(view -> this.startCompassCalibrating());
    }

    public CompassStatusWidget(Context context) {
        this(context, null);
    }

    public CompassStatusWidget(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public CompassStatusWidget(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.initialize(context);
    }

    private void initialize(Context context) {
        CompassStatusWidget.inflate((Context)context, (int)R.layout.uxsdk_setting_menu_compass_status_layout, (ViewGroup)this);
        this.initView();
        this.mSettingUiFlycTitles.get(0).setSelected(true);
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        if (this.isInEditMode()) {
            return;
        }
        KeyManager.getInstance().getValue(KeyTools.createKey((DJIKeyInfo)ProductKey.KeyProductType), (CommonCallbacks.CompletionCallbackWithParam)new CommonCallbacks.CompletionCallbackWithParam<ProductType>(){

            public void onSuccess(ProductType productType) {
                CompassStatusWidget.this.updateViewsByState();
            }

            public void onFailure(@NonNull IDJIError error) {
            }
        });
        KeyManager.getInstance().listen(KeyTools.createKey((DJIKeyInfo)FlightControllerKey.KeyCompassState), (Object)this, (oldValue, newValue) -> {
            this.mCompassStateList = newValue;
            this.updateViewsByState();
        });
        KeyManager.getInstance().listen(KeyTools.createKey((DJIKeyInfo)FlightControllerKey.KeyRedundancySensorUsedState), (Object)this, (oldValue, newValue) -> {
            this.mSensorUsedState = newValue;
            this.updateSelectedSensor(this.mSensorUsedState.getMagIndex());
        });
        KeyManager.getInstance().getValue(KeyTools.createKey((DJIKeyInfo)FlightControllerKey.KeyAreMotorsOn), (CommonCallbacks.CompletionCallbackWithParam)new CommonCallbacks.CompletionCallbackWithParam<Boolean>(){

            public void onSuccess(Boolean isOn) {
                CompassStatusWidget.this.mAreMotorOn = isOn;
            }

            public void onFailure(@NonNull IDJIError error) {
            }
        });
        this.mSimulatorStarted = SimulatorManager.getInstance().isSimulatorEnabled();
        KeyManager.getInstance().listen(KeyTools.createKey((DJIKeyInfo)FlightControllerKey.KeyIsCompassCalibrating), (Object)this, (oldValue, newValue) -> {
            if (newValue != null && newValue.booleanValue()) {
                this.showCompassCalibrationDialog(this.getContext());
            }
        });
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        KeyManager.getInstance().cancelListen((Object)this);
    }

    protected void startCompassCalibrating() {
        if (!((Boolean)KeyManager.getInstance().getValue(KeyTools.createKey((DJIKeyInfo)FlightControllerKey.KeyConnection), (Object)false)).booleanValue()) {
            ViewUtil.showToast(this.getContext(), R.string.uxsdk_app_check_aircraft_connection, 0);
            return;
        }
        if (this.mAreMotorOn) {
            ViewUtil.showToast(this.getContext(), R.string.uxsdk_setting_ui_redundance_compass_cal_tip, 0);
        } else if (this.mSimulatorStarted) {
            ViewUtil.showToast(this.getContext(), R.string.uxsdk_setting_ui_compass_cal_in_sim_tip, 0);
        } else if (!this.isFastClick(R.id.setting_menu_compass_calibrate, 500)) {
            KeyManager.getInstance().performAction(KeyTools.createKey((DJIActionKeyInfo)FlightControllerKey.KeyStartCompassCalibration), (CommonCallbacks.CompletionCallbackWithParam)new CommonCallbacks.CompletionCallbackWithParam<EmptyMsg>(){

                public void onSuccess(EmptyMsg emptyMsg) {
                    ViewUtil.showToast(CompassStatusWidget.this.getContext(), R.string.uxsdk_setting_ui_flyc_cali_begin, 0);
                }

                public void onFailure(@NonNull IDJIError error) {
                    ViewUtil.showToast(CompassStatusWidget.this.getContext(), R.string.uxsdk_setting_ui_flyc_cali_failed, 0);
                }
            });
        }
    }

    private void updateSelectedSensor(int index) {
        for (int i = 0; i < 3; ++i) {
            this.mSettingUiFlycTitles.get(i).setSelected(index == i + 1);
        }
    }

    private void updateViewsByState() {
        if (this.mCompassStateList == null) {
            return;
        }
        for (int i = 0; i < this.mCompassStateList.size(); ++i) {
            int compassSensorStateValue;
            CompassState compassState = this.mCompassStateList.get(i);
            ProgressStatusWidget statusView = this.mSettingUiFlyValues.get(i);
            TextView tvDesc = this.mSettingUiFlyDescs.get(i);
            this.updateSettingUiFlyCompassLy(i, compassState);
            this.updateCompassStateView(compassState, statusView);
            int n = compassSensorStateValue = compassState.getCompassSensorState() == CompassSensorState.UNKNOWN ? 0 : compassState.getCompassSensorState().value();
            if (compassSensorStateValue >= 0 && compassSensorStateValue < this.mCompassStasActionStrIds.length) {
                tvDesc.setText(this.mCompassStasActionStrIds[compassSensorStateValue]);
            }
            if (compassState.getCompassSensorValue() != -1) {
                statusView.setValue(String.valueOf(compassState.getCompassSensorValue()));
                statusView.mProgressBar.setProgress((int)((float)compassState.getCompassSensorValue().intValue() * 1.0f / 999.0f * 100.0f));
            } else {
                this.updateCompassSensorErrorStateView(statusView, tvDesc, compassSensorStateValue);
            }
            if (!TextUtils.isEmpty((CharSequence)tvDesc.getText())) continue;
            tvDesc.setVisibility(8);
        }
        if (this.mSettingUiFlycCompassLy2.getVisibility() == 0 || this.mSettingUiFlycCompassLy3.getVisibility() == 0) {
            this.mSettingUiFlycTitles.get(0).setText(R.string.uxsdk_setting_ui_redundancy_sensor_compass1_label);
        } else {
            this.mSettingUiFlycTitles.get(0).setText(R.string.uxsdk_setting_ui_redundancy_sensor_compass);
        }
    }

    private void updateSettingUiFlyCompassLy(int i, CompassState compassState) {
        boolean visible;
        boolean bl = visible = compassState.getCompassSensorState() != CompassSensorState.DISCONNECTED;
        if (i == 1) {
            this.mSettingUiFlycCompassLy2.setVisibility(visible ? 0 : 8);
        } else if (i == 2) {
            this.mSettingUiFlycCompassLy3.setVisibility(visible ? 0 : 8);
        }
    }

    private void updateCompassStateView(CompassState compassState, ProgressStatusWidget statusView) {
        if (compassState.getCompassSensorState() == CompassSensorState.NORMAL_MODULUS) {
            statusView.setProgressDrawable(ContextCompat.getDrawable((Context)this.getContext(), (int)R.drawable.uxsdk_setting_ui_status_pgb_green));
        } else if (compassState.getCompassSensorState() == CompassSensorState.WEAK_MODULUS) {
            statusView.setProgressDrawable(ContextCompat.getDrawable((Context)this.getContext(), (int)R.drawable.uxsdk_setting_ui_status_pgb_yellow));
        } else if (compassState.getCompassSensorState() == CompassSensorState.SERIOUS_MODULUS) {
            statusView.setProgressDrawable(ContextCompat.getDrawable((Context)this.getContext(), (int)R.drawable.uxsdk_setting_ui_status_pgb_red));
        }
        statusView.mProgressBar.setVisibility(0);
        statusView.mValueView.setVisibility(0);
    }

    private void updateCompassSensorErrorStateView(ProgressStatusWidget statusView, TextView tvDesc, int compassSensorStateValue) {
        if (compassSensorStateValue >= 0 && compassSensorStateValue < this.mCompassStasActionStrIds.length) {
            tvDesc.setText(this.mCompassStasActionStrIds[compassSensorStateValue]);
            tvDesc.setVisibility(0);
            if (compassSensorStateValue == 1) {
                statusView.mProgressBar.setVisibility(8);
                statusView.mValueView.setVisibility(8);
            }
        } else {
            tvDesc.setVisibility(8);
        }
    }

    public boolean isFastClick(int viewId, int duration) {
        boolean isFast;
        long prevTime = this.sClickTimes.get(viewId);
        long now = System.currentTimeMillis();
        boolean bl = isFast = now - prevTime < (long)duration;
        if (!isFast) {
            this.sClickTimes.put(viewId, now);
        }
        return isFast;
    }

    public void showCompassCalibrationDialog(Context context) {
        if (this.mCalibrationDialog == null) {
            this.mCalibrationDialog = new CompassCalibrationDialog(context);
            this.mCalibrationDialog.setOnDismissListener(dialog -> {
                this.mCalibrationDialog = null;
            });
        }
        if (!this.mCalibrationDialog.isShowing()) {
            this.mCalibrationDialog.show();
        }
    }
}

