/*
 * Decompiled with CFR 0.152.
 */
package dji.v5.ux.visualcamera.zoom;

import android.os.SystemClock;
import androidx.annotation.NonNull;
import dji.sdk.keyvalue.key.CameraKey;
import dji.sdk.keyvalue.key.DJIKey;
import dji.sdk.keyvalue.key.DJIKeyInfo;
import dji.sdk.keyvalue.key.KeyTools;
import dji.sdk.keyvalue.value.camera.ZoomRatiosRange;
import dji.sdk.keyvalue.value.common.CameraLensType;
import dji.sdk.keyvalue.value.common.ComponentIndexType;
import dji.v5.manager.KeyManager;
import dji.v5.ux.core.base.DJISDKModel;
import dji.v5.ux.core.base.ICameraIndex;
import dji.v5.ux.core.base.WidgetModel;
import dji.v5.ux.core.communication.ObservableInMemoryKeyedStore;
import dji.v5.ux.core.util.DataProcessor;
import io.reactivex.rxjava3.core.Emitter;
import io.reactivex.rxjava3.core.Observable;
import io.reactivex.rxjava3.disposables.Disposable;
import java.util.concurrent.TimeUnit;

class FocalZoomWidgetViewModel
extends WidgetModel
implements ICameraIndex {
    private static final int SAMPLE_TIME = 500;
    private ComponentIndexType cameraIndex = ComponentIndexType.LEFT_OR_MAIN;
    private CameraLensType lensType = CameraLensType.CAMERA_LENS_ZOOM;
    private Emitter<Double> mSendFocalLengthEmitter;
    private DJIKey<Double> cameraZoomRatiosKey;
    private DJIKey<Double> thermalZoomRatiosKey;
    private DJIKey<ZoomRatiosRange> cameraZoomRatiosRangeKey;
    private DJIKey<ZoomRatiosRange> thermalZoomRatiosRangeKey;
    public final DataProcessor<Double> focalZoomRatios = DataProcessor.create(0.0);
    public final DataProcessor<ZoomRatiosRange> focalZoomRatiosRange = DataProcessor.create(new ZoomRatiosRange());
    private final DataProcessor<Double> visibleFocalZoomRatios = DataProcessor.create(0.0);
    private final DataProcessor<Double> thermalFocalZoomRatios = DataProcessor.create(0.0);
    private final DataProcessor<ZoomRatiosRange> visibleFocalZoomRatiosRange = DataProcessor.create(new ZoomRatiosRange());
    private final DataProcessor<ZoomRatiosRange> thermalFocalZoomRatiosRange = DataProcessor.create(new ZoomRatiosRange());
    private long mSendFocusDistanceTime = 0L;

    public FocalZoomWidgetViewModel(@NonNull DJISDKModel djiSdkModel, @NonNull ObservableInMemoryKeyedStore uxKeyManager) {
        super(djiSdkModel, uxKeyManager);
    }

    @Override
    protected void inSetup() {
        this.initSendFocalLengthObservable();
        this.cameraZoomRatiosKey = KeyTools.createCameraKey((DJIKeyInfo)CameraKey.KeyCameraZoomRatios, (ComponentIndexType)this.cameraIndex, (CameraLensType)CameraLensType.CAMERA_LENS_ZOOM);
        this.thermalZoomRatiosKey = KeyTools.createCameraKey((DJIKeyInfo)CameraKey.KeyThermalZoomRatios, (ComponentIndexType)this.cameraIndex, (CameraLensType)CameraLensType.CAMERA_LENS_THERMAL);
        this.bindDataProcessor(this.cameraZoomRatiosKey, this.visibleFocalZoomRatios, ratios -> {
            if (this.lensType == CameraLensType.CAMERA_LENS_ZOOM) {
                this.focalZoomRatios.onNext((Double)ratios);
            }
        });
        this.bindDataProcessor(this.thermalZoomRatiosKey, this.thermalFocalZoomRatios, ratios -> {
            if (this.lensType == CameraLensType.CAMERA_LENS_THERMAL) {
                this.focalZoomRatios.onNext((Double)ratios);
            }
        });
        this.cameraZoomRatiosRangeKey = KeyTools.createCameraKey((DJIKeyInfo)CameraKey.KeyCameraZoomRatiosRange, (ComponentIndexType)this.cameraIndex, (CameraLensType)CameraLensType.CAMERA_LENS_ZOOM);
        this.thermalZoomRatiosRangeKey = KeyTools.createCameraKey((DJIKeyInfo)CameraKey.KeyThermalZoomRatiosRange, (ComponentIndexType)this.cameraIndex, (CameraLensType)CameraLensType.CAMERA_LENS_ZOOM);
        this.bindDataProcessor(this.cameraZoomRatiosRangeKey, this.visibleFocalZoomRatiosRange, range -> {
            if (this.lensType == CameraLensType.CAMERA_LENS_ZOOM) {
                this.focalZoomRatiosRange.onNext((ZoomRatiosRange)range);
            }
        });
        this.bindDataProcessor(this.thermalZoomRatiosRangeKey, this.thermalFocalZoomRatiosRange, range -> {
            if (this.lensType == CameraLensType.CAMERA_LENS_THERMAL) {
                this.focalZoomRatiosRange.onNext((ZoomRatiosRange)range);
            }
        });
    }

    @Override
    protected void inCleanup() {
    }

    @Override
    @NonNull
    public ComponentIndexType getCameraIndex() {
        return this.cameraIndex;
    }

    @Override
    @NonNull
    public CameraLensType getLensType() {
        return this.lensType;
    }

    @Override
    public void updateCameraSource(@NonNull ComponentIndexType cameraIndex, @NonNull CameraLensType lensType) {
        this.cameraIndex = cameraIndex;
        this.lensType = lensType;
        this.restart();
    }

    private void initSendFocalLengthObservable() {
        Disposable disposable = Observable.create(emitter -> {
            this.mSendFocalLengthEmitter = emitter;
        }).filter(value -> {
            if (SystemClock.uptimeMillis() - this.mSendFocusDistanceTime > 500L) {
                this.sendFocusDistance((double)value);
                return false;
            }
            return true;
        }).throttleLast(500L, TimeUnit.MILLISECONDS).subscribe(this::sendFocusDistance);
        this.addDisposable(disposable);
    }

    public void setFocusDistance(double value) {
        if (this.mSendFocalLengthEmitter != null) {
            this.mSendFocalLengthEmitter.onNext((Object)value);
        }
    }

    private void sendFocusDistance(double value) {
        this.mSendFocusDistanceTime = SystemClock.uptimeMillis();
        if (this.lensType == CameraLensType.CAMERA_LENS_ZOOM) {
            KeyManager.getInstance().setValue(this.cameraZoomRatiosKey, (Object)value, null);
        } else if (this.lensType == CameraLensType.CAMERA_LENS_THERMAL) {
            KeyManager.getInstance().setValue(this.thermalZoomRatiosKey, (Object)value, null);
        }
    }
}

