/*
 * Decompiled with CFR 0.152.
 */
package dji.v5.ux.mapkit.maplibre.annotations;

import androidx.annotation.ColorInt;
import com.mapbox.geojson.Feature;
import com.mapbox.geojson.FeatureCollection;
import com.mapbox.geojson.Geometry;
import com.mapbox.geojson.LineString;
import com.mapbox.geojson.Point;
import com.mapbox.mapboxsdk.maps.MapboxMap;
import com.mapbox.mapboxsdk.style.layers.Layer;
import com.mapbox.mapboxsdk.style.layers.LineLayer;
import com.mapbox.mapboxsdk.style.layers.PropertyFactory;
import com.mapbox.mapboxsdk.style.layers.PropertyValue;
import com.mapbox.mapboxsdk.style.sources.GeoJsonSource;
import com.mapbox.mapboxsdk.style.sources.Source;
import dji.v5.ux.mapkit.core.models.DJILatLng;
import dji.v5.ux.mapkit.core.models.annotations.DJIPolyline;
import dji.v5.ux.mapkit.core.models.annotations.DJIPolylineOptions;
import dji.v5.ux.mapkit.maplibre.map.MaplibreMapDelegate;
import java.util.ArrayList;
import java.util.List;

public class MLineLayerPolyline
implements DJIPolyline {
    private MapboxMap mapboxMap;
    private LineLayer lineLayer;
    private GeoJsonSource source;
    private MaplibreMapDelegate maplibreMapDelegate;
    private DJIPolylineOptions options;
    private String sourceId;
    private String layerId;
    private final List<DJILatLng> pointsCache = new ArrayList<DJILatLng>();

    private MLineLayerPolyline() {
    }

    public MLineLayerPolyline(MaplibreMapDelegate maplibreMapDelegate, MapboxMap mapboxMap, LineLayer lineLayer, GeoJsonSource source, DJIPolylineOptions options) {
        this.maplibreMapDelegate = maplibreMapDelegate;
        this.mapboxMap = mapboxMap;
        this.lineLayer = lineLayer;
        this.source = source;
        lineLayer.setProperties(new PropertyValue[]{PropertyFactory.lineJoin((String)"round")});
        this.sourceId = source.getId();
        this.layerId = lineLayer.getId();
        this.options = options;
    }

    public void updateSourceLayer() {
        this.source = new GeoJsonSource(this.sourceId);
        this.options.setPoints(this.pointsCache);
        this.setPoints(this.options.getPoints());
        this.mapboxMap.getStyle().addSource((Source)this.source);
        this.lineLayer = new LineLayer(this.layerId, this.sourceId);
        this.setWidth(this.options.getWidth());
        this.setColor(this.options.getColor());
        this.maplibreMapDelegate.updateLayerByZIndex((int)this.options.getZIndex(), (Layer)this.lineLayer);
    }

    @Override
    public void remove() {
        this.maplibreMapDelegate.onPolylineRemove(this);
    }

    @Override
    public void setWidth(float width) {
        if (this.maplibreMapDelegate.isStoppingWorld()) {
            return;
        }
        this.lineLayer.setProperties(new PropertyValue[]{PropertyFactory.lineWidth((Float)Float.valueOf(width / 5.0f))});
    }

    @Override
    public float getWidth() {
        if (this.maplibreMapDelegate.isStoppingWorld()) {
            return 0.0f;
        }
        PropertyValue propertyValue = this.lineLayer.getLineWidth();
        return ((Float)propertyValue.getValue()).floatValue();
    }

    @Override
    public void setPoints(List<DJILatLng> points) {
        this.pointsCache.clear();
        this.pointsCache.addAll(points);
        if (this.maplibreMapDelegate.isStoppingWorld()) {
            return;
        }
        this.options.setPoints(points);
        ArrayList<Point> positionList = new ArrayList<Point>(points.size());
        for (DJILatLng latLng : points) {
            Point position = Point.fromLngLat((double)latLng.getLongitude(), (double)latLng.getLatitude());
            positionList.add(position);
        }
        LineString lineString = LineString.fromLngLats(positionList);
        FeatureCollection featureCollection = FeatureCollection.fromFeatures((Feature[])new Feature[]{Feature.fromGeometry((Geometry)lineString)});
        this.source.setGeoJson(featureCollection);
    }

    @Override
    public List<DJILatLng> getPoints() {
        return this.options.getPoints();
    }

    @Override
    public void setColor(@ColorInt int color2) {
        if (this.maplibreMapDelegate.isStoppingWorld()) {
            return;
        }
        this.lineLayer.setProperties(new PropertyValue[]{PropertyFactory.lineColor((int)color2)});
    }

    @Override
    public int getColor() {
        return this.lineLayer.getLineColorAsInt();
    }

    @Override
    public void setZIndex(float zIndex) {
        if (this.maplibreMapDelegate.isStoppingWorld()) {
            return;
        }
        this.options.zIndex(zIndex);
        this.maplibreMapDelegate.updateLayerByZIndex((int)zIndex, (Layer)this.lineLayer);
    }

    @Override
    public float getZIndex() {
        return this.options.getZIndex();
    }

    public DJIPolylineOptions getOptions() {
        return null;
    }

    public void setOptions(DJIPolylineOptions options) {
        if (this.maplibreMapDelegate.isStoppingWorld()) {
            return;
        }
        this.options = options;
        ArrayList<Point> positionList = new ArrayList<Point>(options.getPoints().size());
        for (DJILatLng latLng : options.getPoints()) {
            Point position = Point.fromLngLat((double)latLng.getLongitude(), (double)latLng.getLatitude());
            positionList.add(position);
        }
        LineString lineString = LineString.fromLngLats(positionList);
        this.source.setGeoJson((Geometry)lineString);
        this.setColor(options.getColor());
        this.setWidth(options.getWidth());
    }

    public String getSourceId() {
        return this.sourceId;
    }

    public String getLayerId() {
        return this.layerId;
    }
}

