/*
 * Decompiled with CFR 0.152.
 */
package dji.v5.ux.core.widget.hd.frequency;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.util.AttributeSet;
import dji.v5.ux.R;
import dji.v5.ux.core.base.BaseView;

public class DistanceLineView
extends BaseView {
    private int mFirstLineNfValue = -91;
    private int mSecondLineNfValue = -103;
    private float mFirstLinePos = 0.0f;
    private float mSecondLinePos = 0.0f;
    private Paint mPaint = new Paint();
    private float mChartHeight;

    public DistanceLineView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.mPaint.setColor(this.getResources().getColor(0x1060000));
        this.mPaint.setStrokeWidth(1.0f);
        this.mPaint.setAlpha(125);
        this.mPaint.setAntiAlias(true);
        this.mChartHeight = this.getResources().getDimension(R.dimen.uxsdk_setting_ui_hd_sdr_chart_height);
        this.mFirstLinePos = this.mChartHeight * (float)(50 - (this.mFirstLineNfValue - -110)) / 50.0f;
        this.mSecondLinePos = this.mChartHeight * (float)(50 - (this.mSecondLineNfValue - -110)) / 50.0f;
    }

    public void set1KmNfValue(int _val) {
        this.mFirstLineNfValue = _val;
        this.mSecondLineNfValue = this.mFirstLineNfValue - 12;
        this.mFirstLinePos = this.mChartHeight * (float)(50 - (this.mFirstLineNfValue - -110)) / 50.0f;
        this.mSecondLinePos = this.mChartHeight * (float)(50 - (this.mSecondLineNfValue - -110)) / 50.0f;
        this.postInvalidate();
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        canvas.drawLine(0.0f, this.mFirstLinePos, (float)canvas.getWidth(), this.mFirstLinePos, this.mPaint);
        canvas.drawLine(0.0f, this.mSecondLinePos, (float)canvas.getWidth(), this.mSecondLinePos, this.mPaint);
    }
}

