/*
 * Decompiled with CFR 0.152.
 */
package dji.v5.ux.core.widget.battery;

import android.content.Context;
import android.text.SpannableStringBuilder;
import android.text.style.ForegroundColorSpan;
import android.util.AttributeSet;
import android.view.ViewGroup;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import dji.v5.utils.common.AndUtil;
import dji.v5.utils.common.LogUtils;
import dji.v5.ux.R;
import dji.v5.ux.core.base.DJISDKModel;
import dji.v5.ux.core.base.widget.BasicRangeSeekBar;
import dji.v5.ux.core.base.widget.ConstraintLayoutWidget;
import dji.v5.ux.core.communication.ObservableInMemoryKeyedStore;
import dji.v5.ux.core.widget.battery.BatteryAlertWidgetModel;
import java.util.Locale;

public class BatteryAlertWidget
extends ConstraintLayoutWidget<Object>
implements BasicRangeSeekBar.OnRangeSeekBarListener {
    private static final String TAG = "BatteryAlertWidget";
    private static final int GO_HOME_MAX = 50;
    private static final int LANDING_MIN = 10;
    private static final int LANDING_GAP = 5;
    protected BatteryAlertWidgetModel widgetModel = new BatteryAlertWidgetModel(DJISDKModel.getInstance(), ObservableInMemoryKeyedStore.getInstance());
    protected TextView mTvSeriousLowBattery;
    protected TextView mTvLowBattery;
    protected BasicRangeSeekBar mBasicRangeSeekBar;
    protected int lowBatteryValue = -1;
    protected int seriousLowBatteryValue = -1;

    public BatteryAlertWidget(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    public BatteryAlertWidget(@NonNull Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
    }

    public BatteryAlertWidget(@NonNull Context context) {
        super(context);
    }

    @Override
    protected void initView(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        BatteryAlertWidget.inflate((Context)context, (int)R.layout.uxsdk_setting_menu_battery_controller_layout, (ViewGroup)this);
        this.mTvSeriousLowBattery = (TextView)this.findViewById(R.id.tv_serious_low_battery_title);
        this.mTvLowBattery = (TextView)this.findViewById(R.id.tv_low_battery_title);
        this.mBasicRangeSeekBar = (BasicRangeSeekBar)this.findViewById(R.id.checklist_item_range_seek_bar);
        this.mBasicRangeSeekBar.setRange(10.0f, 50.0f, 1.0f, 5.0f);
        this.mBasicRangeSeekBar.setListener(this);
    }

    @Override
    protected void reactToModelChanges() {
        this.addReaction(this.widgetModel.getLowBatteryWarning().subscribe(value -> {
            this.lowBatteryValue = value;
            this.updateProgress();
        }));
        this.addReaction(this.widgetModel.getSeriousLowBatteryWarning().subscribe(integer2 -> {
            this.seriousLowBatteryValue = integer2;
            this.updateProgress();
        }));
        this.addReaction(this.widgetModel.getConnection().subscribe(isConnected -> {
            this.mBasicRangeSeekBar.setEnabled((boolean)isConnected);
            if (Boolean.TRUE.equals(isConnected)) {
                this.mTvLowBattery.setVisibility(0);
                this.mTvSeriousLowBattery.setVisibility(0);
                return;
            }
            this.mTvLowBattery.setVisibility(8);
            this.mTvSeriousLowBattery.setVisibility(8);
            this.lowBatteryValue = -1;
            this.seriousLowBatteryValue = -1;
            this.onValuesChanging(0.0f, 0.0f);
            this.mBasicRangeSeekBar.setCurrentValues(10.0f, 50.0f);
        }));
    }

    @Override
    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        if (!this.isInEditMode()) {
            this.widgetModel.setup();
        }
    }

    @Override
    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        if (!this.isInEditMode()) {
            this.widgetModel.cleanup();
        }
    }

    @Override
    public void onValuesChanging(float newSeriousLow, float newLow) {
        String newSeriousLowText = String.format(Locale.getDefault(), "%02d%%", (int)newSeriousLow);
        String newLowText = String.format(Locale.getDefault(), "%02d%%", (int)newLow);
        this.updateText(this.mTvSeriousLowBattery, R.string.uxsdk_checklist_manual_serious_low_battery_percent, newSeriousLowText, AndUtil.getResColor((int)R.color.uxsdk_red_in_dark));
        this.updateText(this.mTvLowBattery, R.string.uxsdk_checklist_manual_low_battery_percent, newLowText, AndUtil.getResColor((int)R.color.uxsdk_orange_in_dark));
    }

    @Override
    public void onValuesChanged(float newSeriousLow, float newLow) {
        if (this.lowBatteryValue != (int)newLow) {
            this.addDisposable(this.widgetModel.changeLowBatteryWarning((int)newLow).subscribe(() -> {}, throwable -> {
                LogUtils.e((String)TAG, (Object[])new Object[]{"changeLowBatteryWarning fail: " + throwable});
                this.updateProgress();
            }));
        }
        if (this.seriousLowBatteryValue != (int)newSeriousLow) {
            this.addDisposable(this.widgetModel.changeSeriousLowBatteryWarning((int)newSeriousLow).subscribe(() -> {}, throwable -> {
                LogUtils.e((String)TAG, (Object[])new Object[]{"changeSeriousLowBatteryWarning fail: " + throwable});
                this.updateProgress();
            }));
        }
    }

    private void updateProgress() {
        if (this.seriousLowBatteryValue <= 0 || this.lowBatteryValue <= 0 || !this.mBasicRangeSeekBar.isEnabled()) {
            return;
        }
        this.mBasicRangeSeekBar.setCurrentValues(this.seriousLowBatteryValue, this.lowBatteryValue);
        this.onValuesChanging(this.seriousLowBatteryValue, this.lowBatteryValue);
    }

    private void updateText(TextView textView, int res, String value, int valueColor) {
        String rawText = AndUtil.getResString((int)res, (Object[])new Object[]{value});
        SpannableStringBuilder spannableString = new SpannableStringBuilder((CharSequence)rawText);
        ForegroundColorSpan foregroundColorSpan = new ForegroundColorSpan(valueColor);
        int start = rawText.indexOf(value);
        int end = start + value.length();
        spannableString.setSpan((Object)foregroundColorSpan, start, end, 33);
        textView.setText((CharSequence)spannableString);
    }
}

