/*
 * Decompiled with CFR 0.152.
 */
package dji.v5.ux.core.base;

import androidx.annotation.NonNull;
import dji.sdk.keyvalue.key.DJIKey;
import dji.sdk.keyvalue.key.DJIKeyInfo;
import dji.sdk.keyvalue.key.KeyTools;
import dji.sdk.keyvalue.key.ProductKey;
import dji.v5.utils.common.LogUtils;
import dji.v5.ux.core.base.BaseModule;
import dji.v5.ux.core.base.DJISDKModel;
import dji.v5.ux.core.communication.ObservableInMemoryKeyedStore;
import dji.v5.ux.core.communication.UXKey;
import dji.v5.ux.core.util.DataProcessor;
import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.disposables.CompositeDisposable;
import io.reactivex.rxjava3.disposables.Disposable;
import io.reactivex.rxjava3.functions.Consumer;
import java.util.ArrayList;
import java.util.List;

public abstract class WidgetModel {
    public final String tag = LogUtils.getTag((Object)this);
    protected final DJISDKModel djiSdkModel;
    protected final ObservableInMemoryKeyedStore uxKeyManager;
    protected DataProcessor<Boolean> productConnectionProcessor;
    private CompositeDisposable keyDisposables;
    private CompositeDisposable compositeDisposable;
    private final List<BaseModule> moduleList = new ArrayList<BaseModule>();
    private StatesChangeListener statesChangedListener;

    protected WidgetModel(@NonNull DJISDKModel djiSdkModel, @NonNull ObservableInMemoryKeyedStore uxKeyManager) {
        this.djiSdkModel = djiSdkModel;
        this.uxKeyManager = uxKeyManager;
        this.productConnectionProcessor = DataProcessor.create(false);
    }

    protected void addModule(@NonNull BaseModule baseModule) {
        if (this.isStarted()) {
            throw new IllegalStateException("WidgetModel is already setup. Modules should be added during initialization.");
        }
        if (!this.moduleList.contains(baseModule)) {
            this.moduleList.add(baseModule);
        }
    }

    public synchronized void setup() {
        if (this.isStarted()) {
            throw new IllegalStateException("WidgetModel is already setup. Call cleanup first.");
        }
        this.keyDisposables = new CompositeDisposable();
        this.compositeDisposable = new CompositeDisposable();
        this.initializeConnection();
        this.inSetup();
        for (BaseModule module : this.moduleList) {
            module.setup(this);
        }
    }

    public synchronized void cleanup() {
        if (this.keyDisposables != null) {
            this.keyDisposables.dispose();
            this.keyDisposables = null;
        }
        if (this.compositeDisposable != null) {
            this.compositeDisposable.dispose();
            this.compositeDisposable = null;
        }
        this.djiSdkModel.removeListener(this);
        for (BaseModule module : this.moduleList) {
            module.cleanup();
        }
        this.statesChangedListener = null;
        this.inCleanup();
    }

    protected void restart() {
        if (this.isStarted()) {
            this.cleanup();
            this.setup();
        }
    }

    protected abstract void inSetup();

    protected abstract void inCleanup();

    protected void updateStates() {
        StatesChangeListener listener2 = this.statesChangedListener;
        if (listener2 != null) {
            listener2.onStatesChanged();
        }
    }

    private boolean isStarted() {
        return this.keyDisposables != null;
    }

    protected void addDisposable(@NonNull Disposable disposable) {
        if (this.compositeDisposable != null) {
            this.compositeDisposable.add(disposable);
        }
    }

    protected void removeDisposable(@NonNull Disposable disposable) {
        if (this.compositeDisposable != null) {
            this.compositeDisposable.remove(disposable);
        }
    }

    private void initializeConnection() {
        DJIKey productConnectionKey = KeyTools.createKey((DJIKeyInfo)ProductKey.KeyConnection);
        this.bindDataProcessor(productConnectionKey, this.productConnectionProcessor, newValue -> this.onProductConnectionChanged((boolean)newValue));
    }

    protected void onProductConnectionChanged(boolean isConnected) {
    }

    protected <T> void bindDataProcessor(@NonNull DJIKey<T> key, @NonNull DataProcessor<T> dataProcessor) {
        this.bindDataProcessor(key, dataProcessor, o -> {});
    }

    protected <T> void bindDataProcessor(@NonNull DJIKey<T> key, @NonNull DataProcessor<T> dataProcessor, @NonNull Consumer<T> sideEffectConsumer) {
        this.registerKey(key, dataProcessor::onNext, sideEffectConsumer);
    }

    protected <T> void bindDataProcessor(@NonNull UXKey key, @NonNull DataProcessor<T> dataProcessor) {
        this.bindDataProcessor(key, dataProcessor, o -> {});
    }

    protected <T> void bindDataProcessor(@NonNull UXKey key, @NonNull DataProcessor<T> dataProcessor, @NonNull Consumer<T> sideEffectConsumer) {
        this.registerKey(key, dataProcessor::onNext, sideEffectConsumer);
    }

    private <T> void registerKey(@NonNull DJIKey<T> djiKey, @NonNull Consumer<T> bindConsumer, @NonNull Consumer<T> sideEffectConsumer) {
        if (this.keyDisposables == null) {
            throw new IllegalStateException("Call this method only when in inSetup");
        }
        this.keyDisposables.add(this.djiSdkModel.addListener(djiKey, this).doOnNext(sideEffectConsumer).doOnNext(bindConsumer).subscribe(o -> this.updateStates(), this.logError(djiKey)));
    }

    private <T> void registerKey(@NonNull UXKey uxKey, @NonNull Consumer<T> bindConsumer, @NonNull Consumer<T> sideEffectConsumer) {
        if (this.keyDisposables == null) {
            throw new IllegalStateException("Call this method only when in inSetup");
        }
        this.keyDisposables.add(this.uxKeyManager.addObserver(uxKey).filter(broadcastValues -> broadcastValues.getCurrentValue().getData() != null).map(broadcastValues -> broadcastValues.getCurrentValue().getData()).doOnNext(o -> sideEffectConsumer.accept(o)).doOnNext(o -> bindConsumer.accept(o)).subscribe(o -> this.updateStates(), this.logError(uxKey)));
    }

    private <T> Consumer<Throwable> logError(@NonNull DJIKey<T> djiKey) {
        return throwable -> LogUtils.e((String)this.tag, (Object[])new Object[]{"Error registering " + djiKey.toString() + ": " + throwable.getMessage()});
    }

    private Consumer<Throwable> logError(@NonNull UXKey uxKey) {
        return throwable -> LogUtils.e((String)this.tag, (Object[])new Object[]{"Error registering " + uxKey.toString() + ": " + throwable.getMessage()});
    }

    public Flowable<Boolean> getProductConnection() {
        return this.productConnectionProcessor.toFlowable();
    }

    public static interface StatesChangeListener {
        public void onStatesChanged();
    }
}

