/*
 * Decompiled with CFR 0.152.
 */
package dji.v5.ux.core.widget.hd.frequency;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.util.AttributeSet;
import dji.v5.ux.R;
import dji.v5.ux.core.base.BaseView;
import java.util.Locale;

public class FreqRangeTextView
extends BaseView {
    private float mMinValue = 0.0f;
    private float mMaxValue = 0.0f;
    private float mPosMinX = 0.0f;
    private float mPosMaxX = 0.0f;
    private float mMarginLeft = 0.0f;
    private Paint mPaint;
    private float mTxtSize = this.getResources().getDimension(R.dimen.uxsdk_text_size_small);
    private int mTxtNum = 6;

    public FreqRangeTextView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.mPaint = new Paint();
        this.mPaint.setColor(this.getResources().getColor(17170443));
        this.mPaint.setTextSize(this.mTxtSize);
        this.mPaint.setAntiAlias(true);
        this.mMarginLeft = this.getResources().getDimension(R.dimen.uxsdk_setting_ui_hd_sdr_chart_left_axis_width);
    }

    public void setMinMaxValue(float _min, float _max, float posMin, float posMax) {
        this.mMinValue = _min;
        this.mMaxValue = _max;
        this.mPosMinX = posMin;
        this.mPosMaxX = posMax;
        this.postInvalidate();
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        float offset = this.mTxtSize / 4.0f * (float)this.mTxtNum;
        canvas.drawText(String.format(Locale.US, "%.1f", Float.valueOf(this.mMinValue)), this.mMarginLeft + this.mPosMinX - offset - this.mTxtSize / 2.0f, this.mTxtSize * 1.5f, this.mPaint);
        canvas.drawText(String.format(Locale.US, "%.1f", Float.valueOf(this.mMaxValue)), this.mMarginLeft + this.mPosMaxX - offset + this.mTxtSize / 2.0f, this.mTxtSize * 1.5f, this.mPaint);
    }
}

