/*
 * Decompiled with CFR 0.152.
 */
package dji.v5.ux.mapkit.maplibre.annotations;

import android.graphics.Color;
import com.mapbox.geojson.Geometry;
import com.mapbox.geojson.LineString;
import com.mapbox.geojson.Point;
import com.mapbox.geojson.Polygon;
import com.mapbox.mapboxsdk.geometry.LatLng;
import com.mapbox.mapboxsdk.maps.MapboxMap;
import com.mapbox.mapboxsdk.maps.Style;
import com.mapbox.mapboxsdk.style.layers.FillLayer;
import com.mapbox.mapboxsdk.style.layers.Layer;
import com.mapbox.mapboxsdk.style.layers.LineLayer;
import com.mapbox.mapboxsdk.style.layers.PropertyFactory;
import com.mapbox.mapboxsdk.style.layers.PropertyValue;
import com.mapbox.mapboxsdk.style.sources.GeoJsonSource;
import com.mapbox.mapboxsdk.style.sources.Source;
import com.mapbox.turf.TurfMeta;
import com.mapbox.turf.TurfTransformation;
import dji.v5.ux.mapkit.core.models.DJILatLng;
import dji.v5.ux.mapkit.core.models.annotations.DJICircle;
import dji.v5.ux.mapkit.core.models.annotations.DJICircleOptions;
import dji.v5.ux.mapkit.core.utils.DJIMapkitLog;
import dji.v5.ux.mapkit.maplibre.utils.MapboxExtension;
import dji.v5.ux.mapkit.maplibre.utils.MapboxUtil;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000|\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u0007\n\u0002\b\u0007\u0018\u0000 O2\u00020\u0001:\u0001OB\u0087\u0001\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00126\u0010\u0006\u001a2\u0012\u0013\u0012\u00110\b\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\u000b\u0012\u0013\u0012\u00110\u0000\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\f\u0012\u0004\u0012\u00020\r0\u0007\u00126\u0010\u000e\u001a2\u0012\u0013\u0012\u00110\b\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\u000b\u0012\u0013\u0012\u00110\u0000\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\u000f\u0012\u0004\u0012\u00020\u00100\u0007\u00a2\u0006\u0004\b\u0011\u0010\u0012J\b\u0010*\u001a\u00020\u0010H\u0016J\u0010\u0010+\u001a\u00020\u00102\u0006\u0010,\u001a\u00020\rH\u0016J\b\u0010-\u001a\u00020\rH\u0016J\u0010\u0010.\u001a\u00020\u00102\u0006\u0010/\u001a\u00020\bH\u0016J\b\u00100\u001a\u00020\bH\u0016J\u0010\u00101\u001a\u00020\u00102\u0006\u0010/\u001a\u00020\bH\u0016J\b\u00102\u001a\u00020\bH\u0016J\u0018\u00103\u001a\u00020\u00102\u0006\u00104\u001a\u0002052\u0006\u00106\u001a\u000207H\u0016J\r\u00108\u001a\u00020\u0010H\u0000\u00a2\u0006\u0002\b9J\r\u0010:\u001a\u00020\u0010H\u0000\u00a2\u0006\u0002\b;J%\u0010<\u001a\n \u0015*\u0004\u0018\u00010\u00140\u00142\u0006\u00104\u001a\u0002052\u0006\u00106\u001a\u000207H\u0002\u00a2\u0006\u0002\u0010=J\u0010\u0010>\u001a\u00020\u00102\u0006\u0010?\u001a\u00020@H\u0002J\u0010\u0010A\u001a\u00020\u00102\u0006\u0010?\u001a\u00020@H\u0002J\b\u0010B\u001a\u00020CH\u0016J\b\u0010D\u001a\u000205H\u0016J\u0010\u0010E\u001a\u00020\u00102\u0006\u00104\u001a\u000205H\u0016J\b\u0010F\u001a\u000207H\u0016J\u0010\u0010G\u001a\u00020\u00102\u0006\u00106\u001a\u000207H\u0016J\b\u0010H\u001a\u00020IH\u0016J\u0010\u0010J\u001a\u00020\u00102\u0006\u0010K\u001a\u00020IH\u0016J\b\u0010L\u001a\u00020IH\u0016J\u0010\u0010M\u001a\u00020\u00102\u0006\u0010N\u001a\u00020IH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R>\u0010\u0006\u001a2\u0012\u0013\u0012\u00110\b\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\u000b\u0012\u0013\u0012\u00110\u0000\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\f\u0012\u0004\u0012\u00020\r0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R>\u0010\u000e\u001a2\u0012\u0013\u0012\u00110\b\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\u000b\u0012\u0013\u0012\u00110\u0000\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\u000f\u0012\u0004\u0012\u00020\u00100\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0013\u001a\n \u0015*\u0004\u0018\u00010\u00140\u0014X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0016R\u001b\u0010\u0017\u001a\u00020\u00188BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001b\u0010\u001c\u001a\u0004\b\u0019\u0010\u001aR\u001b\u0010\u001d\u001a\u00020\u001e8@X\u0080\u0084\u0002\u00a2\u0006\f\n\u0004\b!\u0010\u001c\u001a\u0004\b\u001f\u0010 R\u001b\u0010\"\u001a\u00020\u00188BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b$\u0010\u001c\u001a\u0004\b#\u0010\u001aR\u001b\u0010%\u001a\u00020&8@X\u0080\u0084\u0002\u00a2\u0006\f\n\u0004\b)\u0010\u001c\u001a\u0004\b'\u0010(\u00a8\u0006P"}, d2={"Ldji/v5/ux/mapkit/maplibre/annotations/MaplibreCircle;", "Ldji/v5/ux/mapkit/core/models/annotations/DJICircle;", "mapboxMap", "Lcom/mapbox/mapboxsdk/maps/MapboxMap;", "options", "Ldji/v5/ux/mapkit/core/models/annotations/DJICircleOptions;", "onRemoveCircle", "Lkotlin/Function2;", "", "Lkotlin/ParameterName;", "name", "zindex", "circle", "", "onAddCircle", "polyline", "", "<init>", "(Lcom/mapbox/mapboxsdk/maps/MapboxMap;Ldji/v5/ux/mapkit/core/models/annotations/DJICircleOptions;Lkotlin/jvm/functions/Function2;Lkotlin/jvm/functions/Function2;)V", "borderLineString", "Lcom/mapbox/geojson/LineString;", "kotlin.jvm.PlatformType", "Lcom/mapbox/geojson/LineString;", "source", "Lcom/mapbox/mapboxsdk/style/sources/GeoJsonSource;", "getSource", "()Lcom/mapbox/mapboxsdk/style/sources/GeoJsonSource;", "source$delegate", "Lkotlin/Lazy;", "circleLayer", "Lcom/mapbox/mapboxsdk/style/layers/FillLayer;", "getCircleLayer$android_sdk_v5_uxsdk_release", "()Lcom/mapbox/mapboxsdk/style/layers/FillLayer;", "circleLayer$delegate", "borderSource", "getBorderSource", "borderSource$delegate", "borderLayer", "Lcom/mapbox/mapboxsdk/style/layers/LineLayer;", "getBorderLayer$android_sdk_v5_uxsdk_release", "()Lcom/mapbox/mapboxsdk/style/layers/LineLayer;", "borderLayer$delegate", "remove", "setVisible", "visible", "isVisible", "setFillColor", "color", "getFillColor", "setStrokeColor", "getStrokeColor", "setCircle", "center", "Ldji/v5/ux/mapkit/core/models/DJILatLng;", "radius", "", "clearCircle", "clearCircle$android_sdk_v5_uxsdk_release", "restore", "restore$android_sdk_v5_uxsdk_release", "getLineString", "(Ldji/v5/ux/mapkit/core/models/DJILatLng;D)Lcom/mapbox/geojson/LineString;", "setUpBorderSource", "style", "Lcom/mapbox/mapboxsdk/maps/Style;", "setUpCircleSource", "toString", "", "getCenter", "setCenter", "getRadius", "setRadius", "getStrokeWidth", "", "setStrokeWidth", "strokeWidth", "getZIndex", "setZIndex", "zIndex", "Companion", "android-sdk-v5-uxsdk_release"})
public final class MaplibreCircle
implements DJICircle {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final MapboxMap mapboxMap;
    @NotNull
    private final DJICircleOptions options;
    @NotNull
    private final Function2<Integer, MaplibreCircle, Boolean> onRemoveCircle;
    @NotNull
    private final Function2<Integer, MaplibreCircle, Unit> onAddCircle;
    private final LineString borderLineString;
    @NotNull
    private final Lazy source$delegate;
    @NotNull
    private final Lazy circleLayer$delegate;
    @NotNull
    private final Lazy borderSource$delegate;
    @NotNull
    private final Lazy borderLayer$delegate;
    @NotNull
    private static final String TAG = "MapboxCircle";

    public MaplibreCircle(@NotNull MapboxMap mapboxMap, @NotNull DJICircleOptions options, @NotNull Function2<? super Integer, ? super MaplibreCircle, Boolean> onRemoveCircle, @NotNull Function2<? super Integer, ? super MaplibreCircle, Unit> onAddCircle) {
        block1: {
            Intrinsics.checkNotNullParameter((Object)mapboxMap, (String)"mapboxMap");
            Intrinsics.checkNotNullParameter((Object)options, (String)"options");
            Intrinsics.checkNotNullParameter(onRemoveCircle, (String)"onRemoveCircle");
            Intrinsics.checkNotNullParameter(onAddCircle, (String)"onAddCircle");
            this.mapboxMap = mapboxMap;
            this.options = options;
            this.onRemoveCircle = onRemoveCircle;
            this.onAddCircle = onAddCircle;
            DJILatLng dJILatLng = this.options.getCenter();
            Intrinsics.checkNotNullExpressionValue((Object)dJILatLng, (String)"getCenter(...)");
            this.borderLineString = this.getLineString(dJILatLng, this.options.getRadius());
            this.source$delegate = LazyKt.lazy(() -> MaplibreCircle.source_delegate$lambda$0(this));
            this.circleLayer$delegate = LazyKt.lazy(() -> MaplibreCircle.circleLayer_delegate$lambda$2(this));
            this.borderSource$delegate = LazyKt.lazy(() -> MaplibreCircle.borderSource_delegate$lambda$3(this));
            this.borderLayer$delegate = LazyKt.lazy(() -> MaplibreCircle.borderLayer_delegate$lambda$4(this));
            DJIMapkitLog.i(TAG, "init");
            Style style2 = this.mapboxMap.getStyle();
            if (style2 == null) break block1;
            Style it = style2;
            boolean bl = false;
            if (it.isFullyLoaded()) {
                this.setUpCircleSource(it);
                this.setUpBorderSource(it);
            }
        }
    }

    private final GeoJsonSource getSource() {
        Lazy lazy = this.source$delegate;
        return (GeoJsonSource)lazy.getValue();
    }

    @NotNull
    public final FillLayer getCircleLayer$android_sdk_v5_uxsdk_release() {
        Lazy lazy = this.circleLayer$delegate;
        return (FillLayer)lazy.getValue();
    }

    private final GeoJsonSource getBorderSource() {
        Lazy lazy = this.borderSource$delegate;
        return (GeoJsonSource)lazy.getValue();
    }

    @NotNull
    public final LineLayer getBorderLayer$android_sdk_v5_uxsdk_release() {
        Lazy lazy = this.borderLayer$delegate;
        return (LineLayer)lazy.getValue();
    }

    @Override
    public void remove() {
        block1: {
            DJIMapkitLog.i(TAG, "remove " + this.getCircleLayer$android_sdk_v5_uxsdk_release().getId() + ", " + this.getBorderLayer$android_sdk_v5_uxsdk_release().getId());
            Style style2 = this.mapboxMap.getStyle();
            if (style2 == null) break block1;
            Style it = style2;
            boolean bl = false;
            if (!((Boolean)this.onRemoveCircle.invoke((Object)((int)this.options.getZIndex()), (Object)this)).booleanValue()) {
                DJIMapkitLog.e(TAG, "remove circle " + this + " fail");
            }
            MapboxExtension.removeLayerAndLog(it, (Layer)this.getCircleLayer$android_sdk_v5_uxsdk_release());
            MapboxExtension.removeLayerAndLog(it, (Layer)this.getBorderLayer$android_sdk_v5_uxsdk_release());
            MapboxExtension.removeSourceAndLog(it, (Source)this.getSource());
            MapboxExtension.removeSourceAndLog(it, (Source)this.getBorderSource());
        }
    }

    @Override
    public void setVisible(boolean visible) {
        PropertyValue[] propertyValueArray = new PropertyValue[]{PropertyFactory.visibility((String)(visible ? "visible" : "none"))};
        this.getCircleLayer$android_sdk_v5_uxsdk_release().withProperties(propertyValueArray);
        propertyValueArray = new PropertyValue[]{PropertyFactory.visibility((String)(visible ? "visible" : "none"))};
        this.getBorderLayer$android_sdk_v5_uxsdk_release().withProperties(propertyValueArray);
    }

    @Override
    public boolean isVisible() {
        return Intrinsics.areEqual((Object)"visible", (Object)this.getCircleLayer$android_sdk_v5_uxsdk_release().getVisibility().value);
    }

    @Override
    public void setFillColor(int color2) {
        PropertyValue[] propertyValueArray = new PropertyValue[]{PropertyFactory.fillColor((int)color2)};
        this.getCircleLayer$android_sdk_v5_uxsdk_release().withProperties(propertyValueArray);
    }

    @Override
    public int getFillColor() {
        return this.getCircleLayer$android_sdk_v5_uxsdk_release().getFillColorAsInt();
    }

    @Override
    public void setStrokeColor(int color2) {
        PropertyValue[] propertyValueArray = new PropertyValue[]{PropertyFactory.lineColor((int)color2)};
        this.getBorderLayer$android_sdk_v5_uxsdk_release().withProperties(propertyValueArray);
    }

    @Override
    public int getStrokeColor() {
        return this.getBorderLayer$android_sdk_v5_uxsdk_release().getLineColorAsInt();
    }

    public void setCircle(@NotNull DJILatLng center, double radius) {
        Intrinsics.checkNotNullParameter((Object)center, (String)"center");
        LineString it = this.getLineString(center, radius);
        boolean bl = false;
        this.getSource().setGeoJson((Geometry)it);
        this.getBorderSource().setGeoJson((Geometry)it);
    }

    public final void clearCircle$android_sdk_v5_uxsdk_release() {
        block0: {
            Style style2 = this.mapboxMap.getStyle();
            if (style2 == null) break block0;
            Style it = style2;
            boolean bl = false;
            DJIMapkitLog.i(TAG, "clear circle");
            MapboxExtension.removeLayerAndLog(it, (Layer)this.getCircleLayer$android_sdk_v5_uxsdk_release());
            MapboxExtension.removeSourceAndLog(it, (Source)this.getSource());
            MapboxExtension.removeLayerAndLog(it, (Layer)this.getBorderLayer$android_sdk_v5_uxsdk_release());
            MapboxExtension.removeSourceAndLog(it, (Source)this.getBorderSource());
        }
    }

    public final void restore$android_sdk_v5_uxsdk_release() {
        block0: {
            DJIMapkitLog.i(TAG, "restore");
            Style style2 = this.mapboxMap.getStyle();
            if (style2 == null) break block0;
            Style it = style2;
            boolean bl = false;
            MapboxExtension.addSourceAndLog(it, (Source)this.getSource());
            MapboxExtension.addSourceAndLog(it, (Source)this.getBorderSource());
        }
    }

    private final LineString getLineString(DJILatLng center, double radius) {
        LatLng it = MapboxUtil.fromDJILatLng(center);
        boolean bl = false;
        Point centerPoint = Point.fromLngLat((double)it.getLongitude(), (double)it.getLatitude(), (double)it.getAltitude());
        return LineString.fromLngLats((List)TurfMeta.coordAll((Polygon)TurfTransformation.circle((Point)centerPoint, (double)radius, (String)"meters"), (boolean)false));
    }

    private final void setUpBorderSource(Style style2) {
        MapboxExtension.addSourceAndLog(style2, (Source)this.getBorderSource());
    }

    private final void setUpCircleSource(Style style2) {
        MapboxExtension.addSourceAndLog(style2, (Source)this.getSource());
    }

    @NotNull
    public String toString() {
        return "MapboxCircle { circle layer id " + this.getCircleLayer$android_sdk_v5_uxsdk_release().getId() + ", circle source id " + this.getSource().getId() + ", border layer id " + this.getBorderLayer$android_sdk_v5_uxsdk_release().getId() + ", border source id " + this.getBorderSource().getId() + "}";
    }

    @Override
    @NotNull
    public DJILatLng getCenter() {
        DJILatLng dJILatLng = this.options.getCenter();
        Intrinsics.checkNotNullExpressionValue((Object)dJILatLng, (String)"getCenter(...)");
        return dJILatLng;
    }

    @Override
    public void setCenter(@NotNull DJILatLng center) {
        Intrinsics.checkNotNullParameter((Object)center, (String)"center");
        this.options.center(center);
        this.setCircle(center, this.getRadius());
    }

    @Override
    public double getRadius() {
        return this.options.getRadius();
    }

    @Override
    public void setRadius(double radius) {
        this.options.radius(radius);
        this.setCircle(this.getCenter(), radius);
    }

    @Override
    public float getStrokeWidth() {
        Object object = this.getBorderLayer$android_sdk_v5_uxsdk_release().getLineWidth().getValue();
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.Float");
        return ((Float)object).floatValue() * 5.0f;
    }

    @Override
    public void setStrokeWidth(float strokeWidth) {
        this.options.strokeWidth(strokeWidth);
        PropertyValue[] propertyValueArray = new PropertyValue[]{PropertyFactory.lineWidth((Float)Float.valueOf(strokeWidth / 5.0f))};
        this.getBorderLayer$android_sdk_v5_uxsdk_release().withProperties(propertyValueArray);
    }

    @Override
    public float getZIndex() {
        return this.options.getZIndex();
    }

    @Override
    public void setZIndex(float zIndex) {
        block0: {
            Style style2 = this.mapboxMap.getStyle();
            if (style2 == null) break block0;
            Style it = style2;
            boolean bl = false;
            this.onRemoveCircle.invoke((Object)((int)this.options.getZIndex()), (Object)this);
            this.options.zIndex(zIndex);
            this.onAddCircle.invoke((Object)((int)this.options.getZIndex()), (Object)this);
        }
    }

    private static final GeoJsonSource source_delegate$lambda$0(MaplibreCircle this$0) {
        return new GeoJsonSource(MapboxUtil.getCircleSourceIdAndIncrement(), (Geometry)Polygon.fromOuterInner((LineString)this$0.borderLineString, (LineString[])new LineString[0]));
    }

    private static final FillLayer circleLayer_delegate$lambda$2(MaplibreCircle this$0) {
        int it = this$0.options.getFillColor();
        boolean bl = false;
        int solid = Color.rgb((int)Color.red((int)it), (int)Color.green((int)it), (int)Color.blue((int)it));
        float alpha = (float)Color.alpha((int)it) / 255.0f;
        PropertyValue[] propertyValueArray = new PropertyValue[]{PropertyFactory.fillColor((int)solid), PropertyFactory.fillOpacity((Float)Float.valueOf(alpha))};
        return new FillLayer(MapboxUtil.getCircleLayerIdAndIncrement(), this$0.getSource().getId()).withProperties(propertyValueArray);
    }

    private static final GeoJsonSource borderSource_delegate$lambda$3(MaplibreCircle this$0) {
        return new GeoJsonSource(MapboxUtil.getCircleBorderSourceIdAndIncrement(), (Geometry)this$0.borderLineString);
    }

    private static final LineLayer borderLayer_delegate$lambda$4(MaplibreCircle this$0) {
        PropertyValue[] propertyValueArray = new PropertyValue[]{PropertyFactory.lineColor((int)this$0.options.getStrokeColor()), PropertyFactory.lineWidth((Float)Float.valueOf(this$0.options.getStrokeWidth() / 5.0f))};
        return new LineLayer(MapboxUtil.getCircleBorderLayerIdAndIncrement(), this$0.getBorderSource().getId()).withProperties(propertyValueArray);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Ldji/v5/ux/mapkit/maplibre/annotations/MaplibreCircle$Companion;", "", "<init>", "()V", "TAG", "", "android-sdk-v5-uxsdk_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

