/*
 * Decompiled with CFR 0.152.
 */
package dji.v5.ux.mapkit.core.models;

import androidx.annotation.NonNull;
import dji.v5.ux.mapkit.core.exceptions.InvalidLatLngBoundsException;
import dji.v5.ux.mapkit.core.models.DJILatLng;
import java.util.ArrayList;
import java.util.List;

public class DJILatLngBounds {
    private final DJILatLng northeast;
    private final DJILatLng southwest;

    private DJILatLngBounds(DJILatLng northeast, DJILatLng southwest) {
        this.northeast = northeast;
        this.southwest = southwest;
    }

    public DJILatLng getNortheast() {
        return this.northeast;
    }

    public DJILatLng getSouthwest() {
        return this.southwest;
    }

    public static DJILatLngBounds fromLatLngs(List<DJILatLng> latLngs) {
        double minLat = 90.0;
        double minLon = 180.0;
        double maxLat = -90.0;
        double maxLon = -180.0;
        for (DJILatLng point : latLngs) {
            double latitude = point.latitude;
            double longitude = point.longitude;
            minLat = Math.min(minLat, latitude);
            minLon = Math.min(minLon, longitude);
            maxLat = Math.max(maxLat, latitude);
            maxLon = Math.max(maxLon, longitude);
        }
        DJILatLng northeast = new DJILatLng(maxLat, maxLon);
        DJILatLng southwest = new DJILatLng(minLat, minLon);
        return new DJILatLngBounds(northeast, southwest);
    }

    public static final class Builder {
        private List<DJILatLng> mLatLngList = new ArrayList<DJILatLng>();

        public DJILatLngBounds build() {
            if (this.mLatLngList.size() < 2) {
                throw new InvalidLatLngBoundsException(this.mLatLngList.size());
            }
            return DJILatLngBounds.fromLatLngs(this.mLatLngList);
        }

        public Builder includes(List<DJILatLng> latLngs) {
            for (DJILatLng point : latLngs) {
                this.mLatLngList.add(point);
            }
            return this;
        }

        public Builder include(@NonNull DJILatLng latLng) {
            this.mLatLngList.add(latLng);
            return this;
        }
    }
}

