/*
 * Decompiled with CFR 0.152.
 */
package dji.v5.ux.core.util;

import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.VectorDrawable;
import android.util.LruCache;
import androidx.annotation.DrawableRes;
import androidx.annotation.NonNull;
import dji.v5.utils.common.ContextUtil;

public class DrawUtils {
    private static final LruCache<Integer, VectorDrawable> vectorDrawableLruCache = new LruCache(30);
    private static final LruCache<Integer, Bitmap> bitmapLruCache = new BitmapLruCache(0x100000);

    private DrawUtils() {
    }

    public static synchronized Bitmap drawableRes2Bitmap(@DrawableRes int resId) {
        Bitmap bitmap = (Bitmap)bitmapLruCache.get((Object)resId);
        if (bitmap == null || bitmap.isRecycled()) {
            bitmap = DrawUtils.drawable2Bitmap(DrawUtils.getDrawable(resId));
            bitmapLruCache.put((Object)resId, (Object)bitmap);
        }
        return bitmap;
    }

    public static synchronized Drawable getDrawable(int resId) {
        Drawable drawable2 = (Drawable)vectorDrawableLruCache.get((Object)resId);
        if (null == drawable2 && (drawable2 = ContextUtil.getContext().getResources().getDrawable(resId)) instanceof VectorDrawable) {
            vectorDrawableLruCache.put((Object)resId, (Object)((VectorDrawable)drawable2));
        }
        return drawable2;
    }

    public static synchronized Bitmap drawable2Bitmap(@NonNull Drawable drawable2) {
        if (drawable2 instanceof BitmapDrawable) {
            return ((BitmapDrawable)drawable2).getBitmap();
        }
        int width = drawable2.getMinimumWidth();
        int height = drawable2.getMinimumHeight();
        Bitmap.Config config = drawable2.getOpacity() != -1 ? Bitmap.Config.ARGB_8888 : Bitmap.Config.RGB_565;
        Bitmap bitmap = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)config);
        Canvas canvas = new Canvas(bitmap);
        drawable2.setBounds(0, 0, width, height);
        drawable2.draw(canvas);
        return bitmap;
    }

    private static class BitmapLruCache
    extends LruCache<Integer, Bitmap> {
        public BitmapLruCache(int maxSize) {
            super(maxSize);
        }

        protected int sizeOf(Integer key, Bitmap value) {
            return value.getByteCount();
        }
    }
}

