/*
 * Decompiled with CFR 0.152.
 */
package dji.v5.ux.cameracore.widget.fpvinteraction;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import android.os.Handler;
import android.util.AttributeSet;
import android.util.Pair;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import androidx.annotation.AnimatorRes;
import androidx.annotation.DrawableRes;
import androidx.annotation.FloatRange;
import androidx.annotation.IntRange;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import dji.sdk.keyvalue.value.common.CameraLensType;
import dji.sdk.keyvalue.value.common.ComponentIndexType;
import dji.sdk.keyvalue.value.common.PhysicalSource;
import dji.v5.ux.R;
import dji.v5.ux.cameracore.widget.fpvinteraction.ExposureMeteringWidget;
import dji.v5.ux.cameracore.widget.fpvinteraction.FPVInteractionWidgetModel;
import dji.v5.ux.cameracore.widget.fpvinteraction.FocusTargetView;
import dji.v5.ux.cameracore.widget.fpvinteraction.GimbalControlView;
import dji.v5.ux.core.base.DJISDKModel;
import dji.v5.ux.core.base.ICameraIndex;
import dji.v5.ux.core.base.IGimbalIndex;
import dji.v5.ux.core.base.SchedulerProvider;
import dji.v5.ux.core.base.widget.FrameLayoutWidget;
import dji.v5.ux.core.communication.GlobalPreferencesManager;
import dji.v5.ux.core.communication.ObservableInMemoryKeyedStore;
import dji.v5.ux.core.util.SettingDefinitions;
import dji.v5.ux.core.util.UxErrorHandle;
import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.disposables.Disposable;
import java.util.concurrent.atomic.AtomicBoolean;

public class FPVInteractionWidget
extends FrameLayoutWidget<Object>
implements View.OnTouchListener,
ICameraIndex,
IGimbalIndex {
    private static final String TAG = "FPVInteractionWidget";
    private static final int LONG_PRESS_TIME = 500;
    private static final float DEFAULT_VELOCITY_FACTOR = 16.0f;
    private final Handler handler = new Handler();
    private FocusTargetView focusTargetView;
    private ExposureMeteringWidget exposureMeterView;
    private GimbalControlView gimbalControlView;
    private FPVInteractionWidgetModel widgetModel;
    private int relativeViewHeight;
    private int relativeViewWidth;
    private float oldAbsTargetX;
    private float oldAbsTargetY;
    private float absTargetX;
    private float absTargetY;
    private int viewHeight;
    private int viewWidth;
    private int widthOffset;
    private int heightOffset;
    private boolean touchFocusEnabled = true;
    private boolean spotMeteringEnabled = true;
    private boolean gimbalControlEnabled = true;
    private float firstX;
    private float firstY;
    private float moveDeltaX;
    private float moveDeltaY;
    private float velocityFactor;
    private AtomicBoolean isInteractionEnabledAtomic;
    private String cameraName;
    private final Runnable longPressed = () -> {
        this.gimbalControlView.show(this.absTargetX, this.absTargetY);
        this.firstX = this.absTargetX;
        this.firstY = this.absTargetY;
    };

    public FPVInteractionWidget(@NonNull Context context) {
        super(context);
    }

    public FPVInteractionWidget(@NonNull Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
    }

    public FPVInteractionWidget(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    @Override
    protected void initView(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        FPVInteractionWidget.inflate((Context)context, (int)R.layout.uxsdk_widget_fpv_interaction, (ViewGroup)this);
        this.focusTargetView = (FocusTargetView)this.findViewById(R.id.view_focus_target);
        this.exposureMeterView = (ExposureMeteringWidget)this.findViewById(R.id.view_exposure_meter);
        this.gimbalControlView = (GimbalControlView)this.findViewById(R.id.view_gimbal_control);
        this.setOnTouchListener(this);
        this.velocityFactor = 16.0f;
        this.isInteractionEnabledAtomic = new AtomicBoolean(true);
        this.cameraName = "";
        if (!this.isInEditMode()) {
            this.widgetModel = new FPVInteractionWidgetModel(DJISDKModel.getInstance(), ObservableInMemoryKeyedStore.getInstance(), GlobalPreferencesManager.getInstance());
        }
        if (attrs != null) {
            this.initAttributes(this.getContext(), attrs);
        }
    }

    @Override
    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        if (!this.isInEditMode()) {
            this.widgetModel.setup();
        }
    }

    @Override
    protected void onDetachedFromWindow() {
        if (!this.isInEditMode()) {
            this.widgetModel.cleanup();
        }
        super.onDetachedFromWindow();
    }

    @Override
    protected void reactToModelChanges() {
        this.addReaction(this.reactToUpdateVisibility());
    }

    private Disposable reactToUpdateVisibility() {
        return Flowable.combineLatest(this.widgetModel.getControlMode(), this.widgetModel.isAeLocked(), Pair::new).observeOn(SchedulerProvider.ui()).subscribe(values -> this.updateViewVisibility((SettingDefinitions.ControlMode)((Object)((Object)values.first)), (Boolean)values.second), UxErrorHandle.logErrorConsumer(TAG, "reactToUpdateVisibility: "));
    }

    private void updateViewVisibility(SettingDefinitions.ControlMode controlMode, boolean isAeLocked) {
        if (controlMode == SettingDefinitions.ControlMode.SPOT_METER || controlMode == SettingDefinitions.ControlMode.CENTER_METER) {
            if (isAeLocked) {
                this.exposureMeterView.setVisibility(8);
            } else if (controlMode == SettingDefinitions.ControlMode.SPOT_METER) {
                this.exposureMeterView.setVisibility(0);
            }
            this.focusTargetView.setVisibility(8);
        } else {
            this.exposureMeterView.setVisibility(8);
            this.focusTargetView.setVisibility(0);
            this.focusTargetView.setControlMode(controlMode);
        }
    }

    public boolean onTouch(View v, MotionEvent event) {
        this.oldAbsTargetX = this.absTargetX;
        this.oldAbsTargetY = this.absTargetY;
        this.absTargetX = event.getX();
        this.absTargetY = event.getY();
        this.viewHeight = v.getHeight();
        this.viewWidth = v.getWidth();
        if (this.relativeViewWidth == 0 && this.relativeViewHeight == 0) {
            this.relativeViewWidth = this.viewWidth;
            this.relativeViewHeight = this.viewHeight;
        }
        this.widthOffset = (this.viewWidth - this.relativeViewWidth) / 2;
        if (this.widthOffset < 0) {
            this.widthOffset = 0;
        }
        this.heightOffset = (this.viewHeight - this.relativeViewHeight) / 2;
        if (this.heightOffset < 0) {
            this.heightOffset = 0;
        }
        switch (event.getAction()) {
            case 0: {
                if (!(this.absTargetX > (float)this.widthOffset) || !((float)this.viewWidth - this.absTargetX > (float)this.widthOffset) || !this.gimbalControlEnabled) break;
                this.handler.postDelayed(this.longPressed, 500L);
                break;
            }
            case 1: {
                this.handler.removeCallbacks(this.longPressed);
                if (this.gimbalControlView.isVisible()) {
                    if (this.absTargetX < (float)this.widthOffset) {
                        this.absTargetX = (float)this.widthOffset + 1.0f;
                    } else if ((float)this.viewWidth - this.absTargetX < (float)this.widthOffset) {
                        this.absTargetX = (float)(this.viewWidth - this.widthOffset) - 1.0f;
                    }
                    this.gimbalControlView.hide();
                    this.stopGimbalRotation();
                    break;
                }
                float targetX = this.absTargetX / (float)this.viewWidth;
                float targetY = this.absTargetY / (float)this.viewHeight;
                this.addDisposable(Flowable.combineLatest(this.widgetModel.getControlMode(), this.widgetModel.isAeLocked(), Pair::new).firstOrError().observeOn(SchedulerProvider.ui()).subscribe(values -> this.updateTarget((SettingDefinitions.ControlMode)((Object)((Object)values.first)), (Boolean)values.second, targetX, targetY), UxErrorHandle.logErrorConsumer(TAG, "Update Target: ")));
                break;
            }
            case 2: {
                if (this.absTargetX < (float)this.widthOffset) {
                    this.absTargetX = (float)this.widthOffset + 1.0f;
                } else if ((float)this.viewWidth - this.absTargetX < (float)this.widthOffset) {
                    this.absTargetX = (float)(this.viewWidth - this.widthOffset) - 1.0f;
                }
                if (this.absTargetY < (float)this.heightOffset) {
                    this.absTargetY = (float)this.heightOffset + 1.0f;
                } else if ((float)this.viewHeight - this.absTargetY < (float)this.heightOffset) {
                    this.absTargetY = (float)(this.viewHeight - this.heightOffset) - 1.0f;
                }
                if (!this.gimbalControlView.isVisible()) break;
                this.gimbalControlView.onMove(this.firstX, this.firstY, this.absTargetX, this.absTargetY, this.widgetModel.canRotateGimbalYaw());
                this.rotateGimbal(this.firstX, this.firstY, this.absTargetX, this.absTargetY);
                break;
            }
        }
        return true;
    }

    @Override
    @Nullable
    public ComponentIndexType getGimbalIndex() {
        return this.widgetModel.getCameraIndex();
    }

    @Override
    public void updateGimbalIndex(@Nullable ComponentIndexType gimbalIndex) {
    }

    @Override
    @NonNull
    public ComponentIndexType getCameraIndex() {
        return this.widgetModel.getCameraIndex();
    }

    @Override
    public void updateCameraSource(@NonNull ComponentIndexType cameraIndex, @NonNull CameraLensType lensType) {
        this.widgetModel.updateCameraSource(cameraIndex, lensType);
        this.exposureMeterView.updateCameraSource(cameraIndex, lensType);
    }

    @Override
    @NonNull
    public CameraLensType getLensType() {
        return this.widgetModel.getLensType();
    }

    public void adjustAspectRatio(@IntRange(from=1L) int width, @IntRange(from=1L) int height) {
        if (width > 0 && height > 0) {
            this.relativeViewWidth = width;
            this.relativeViewHeight = height;
            this.redraw();
        }
    }

    private void updateTarget(SettingDefinitions.ControlMode controlMode, boolean isAeLocked, float targetX, float targetY) {
        if (controlMode == SettingDefinitions.ControlMode.SPOT_METER || controlMode == SettingDefinitions.ControlMode.CENTER_METER) {
            if (this.spotMeteringEnabled && this.isInBounds() && !isAeLocked) {
                SettingDefinitions.ControlMode newControlMode = this.exposureMeterView.clickEvent(controlMode, this.absTargetX, this.absTargetY, this.viewWidth, this.viewHeight);
                this.addDisposable(this.widgetModel.setControlMode(newControlMode).observeOn(SchedulerProvider.ui()).subscribe(() -> {}, UxErrorHandle.logErrorConsumer(TAG, "updateTarget: ")));
                this.addDisposable(this.widgetModel.updateMetering(targetX, targetY).observeOn(SchedulerProvider.ui()).subscribe(() -> {}, throwable -> UxErrorHandle.logErrorConsumer(TAG, "onExposureMeterSetFail: ").accept(throwable)));
            }
        } else if (this.touchFocusEnabled && this.isInBounds()) {
            this.focusTargetView.clickEvent(this.absTargetX, this.absTargetY);
            this.addDisposable(this.widgetModel.updateFocusTarget(targetX, targetY).observeOn(SchedulerProvider.ui()).subscribe(() -> {}, throwable -> this.onFocusTargetSetFail()));
        }
    }

    private boolean isInBounds() {
        return this.absTargetX > (float)this.widthOffset && (float)this.viewWidth - this.absTargetX > (float)this.widthOffset && this.absTargetY > (float)this.heightOffset && (float)this.viewHeight - this.absTargetY > (float)this.heightOffset;
    }

    private void onFocusTargetSetFail() {
        if (this.oldAbsTargetX > 0.0f && this.oldAbsTargetY > 0.0f) {
            this.focusTargetView.clickEvent(this.oldAbsTargetX, this.oldAbsTargetY);
        }
    }

    private void redraw() {
        this.focusTargetView.removeImageBackground();
        this.exposureMeterView.removeImageBackground();
    }

    private void rotateGimbal(float firstX, float firstY, float x, float y) {
        if (this.widgetModel.canRotateGimbalYaw()) {
            this.toggleGimbalRotateBySpeed();
            this.moveDeltaX = x - firstX;
        } else {
            this.moveDeltaX = 0.0f;
        }
        this.moveDeltaY = y - firstY;
    }

    private void stopGimbalRotation() {
        this.moveDeltaX = 0.0f;
        this.moveDeltaY = 0.0f;
    }

    private void toggleGimbalRotateBySpeed() {
        float yawVelocity = this.moveDeltaX / this.velocityFactor;
        float pitchVelocity = this.moveDeltaY / this.velocityFactor;
        if (Math.abs(yawVelocity) >= 1.0f || Math.abs(pitchVelocity) >= 1.0f) {
            this.addDisposable(this.widgetModel.rotateGimbalBySpeed(yawVelocity, -pitchVelocity).observeOn(SchedulerProvider.ui()).subscribe(() -> {}, UxErrorHandle.logErrorConsumer(TAG, "rotate gimbal: ")));
        }
    }

    private void updateVisibility() {
        if (this.isInEditMode()) {
            return;
        }
        if (PhysicalSource.FPV_CAM.toString().equals(this.cameraName) || !this.isInteractionEnabledAtomic.get()) {
            this.setVisibility(8);
        } else {
            this.setVisibility(0);
        }
    }

    private void initAttributes(@NonNull Context context, @NonNull AttributeSet attrs) {
        Drawable gimbalArrowIcon;
        Drawable gimbalMoveIcon;
        Drawable autoFocusContinuousIcon;
        Drawable autoFocusIcon;
        Drawable manualFocusIcon;
        TypedArray typedArray = context.obtainStyledAttributes(attrs, R.styleable.FPVInteractionWidget);
        if (!this.isInEditMode()) {
            this.widgetModel.updateCameraSource(ComponentIndexType.find((int)typedArray.getInt(R.styleable.FPVInteractionWidget_uxsdk_cameraIndex, 0)), CameraLensType.find((int)typedArray.getInt(R.styleable.FPVInteractionWidget_uxsdk_lensType, 0)));
        }
        if ((manualFocusIcon = typedArray.getDrawable(R.styleable.FPVInteractionWidget_uxsdk_manualFocusIcon)) != null) {
            this.setManualFocusIcon(manualFocusIcon);
        }
        if ((autoFocusIcon = typedArray.getDrawable(R.styleable.FPVInteractionWidget_uxsdk_autoFocusIcon)) != null) {
            this.setAutoFocusIcon(autoFocusIcon);
        }
        if ((autoFocusContinuousIcon = typedArray.getDrawable(R.styleable.FPVInteractionWidget_uxsdk_autoFocusContinuousIcon)) != null) {
            this.setAutoFocusContinuousIcon(autoFocusContinuousIcon);
        }
        int focusTargetDuration = typedArray.getInt(R.styleable.FPVInteractionWidget_uxsdk_focusTargetDuration, 2500);
        this.setFocusTargetDuration(focusTargetDuration);
        float centerMeterScaleX = typedArray.getFloat(R.styleable.FPVInteractionWidget_uxsdk_centerMeterScaleX, 1.376f);
        this.setCenterMeterScaleX(centerMeterScaleX);
        float centerMeterScaleY = typedArray.getFloat(R.styleable.FPVInteractionWidget_uxsdk_centerMeterScaleY, 1.0f);
        this.setCenterMeterScaleY(centerMeterScaleY);
        Drawable gimbalPointIcon = typedArray.getDrawable(R.styleable.FPVInteractionWidget_uxsdk_gimbalPointIcon);
        if (gimbalPointIcon != null) {
            this.setGimbalPointIcon(gimbalPointIcon);
        }
        if ((gimbalMoveIcon = typedArray.getDrawable(R.styleable.FPVInteractionWidget_uxsdk_gimbalMoveIcon)) != null) {
            this.setGimbalMoveIcon(gimbalMoveIcon);
        }
        if ((gimbalArrowIcon = typedArray.getDrawable(R.styleable.FPVInteractionWidget_uxsdk_gimbalArrowIcon)) != null) {
            this.setGimbalArrowIcon(gimbalArrowIcon);
        }
        float gimbalVelocityFactor = typedArray.getFloat(R.styleable.FPVInteractionWidget_uxsdk_gimbalVelocityFactor, 16.0f);
        this.setGimbalVelocityFactor(gimbalVelocityFactor);
        boolean isVibrationEnabled = typedArray.getBoolean(R.styleable.FPVInteractionWidget_uxsdk_vibrationEnabled, true);
        this.setVibrationEnabled(isVibrationEnabled);
        int vibrationDuration = typedArray.getInt(R.styleable.FPVInteractionWidget_uxsdk_vibrationDuration, 100);
        this.setVibrationDuration(vibrationDuration);
        this.setInteractionEnabled(typedArray.getBoolean(R.styleable.FPVInteractionWidget_uxsdk_interactionEnabled, true));
        this.touchFocusEnabled = typedArray.getBoolean(R.styleable.FPVInteractionWidget_uxsdk_touchFocusEnabled, true);
        this.spotMeteringEnabled = typedArray.getBoolean(R.styleable.FPVInteractionWidget_uxsdk_spotMeteringEnabled, true);
        this.gimbalControlEnabled = typedArray.getBoolean(R.styleable.FPVInteractionWidget_uxsdk_gimbalControlEnabled, true);
        typedArray.recycle();
    }

    @Override
    @NonNull
    public String getIdealDimensionRatioString() {
        return this.getResources().getString(R.string.uxsdk_widget_fpv_ratio);
    }

    @Nullable
    public Drawable getManualFocusIcon() {
        return this.focusTargetView.getFocusTargetIcon(SettingDefinitions.ControlMode.MANUAL_FOCUS);
    }

    public void setManualFocusIcon(@DrawableRes int resourceId) {
        this.setManualFocusIcon(this.getResources().getDrawable(resourceId));
    }

    public void setManualFocusIcon(@Nullable Drawable icon) {
        this.focusTargetView.setFocusTargetIcon(SettingDefinitions.ControlMode.MANUAL_FOCUS, icon);
    }

    @Nullable
    public Drawable getAutoFocusIcon() {
        return this.focusTargetView.getFocusTargetIcon(SettingDefinitions.ControlMode.AUTO_FOCUS);
    }

    public void setAutoFocusIcon(@DrawableRes int resourceId) {
        this.setAutoFocusIcon(this.getResources().getDrawable(resourceId));
    }

    public void setAutoFocusIcon(@Nullable Drawable icon) {
        this.focusTargetView.setFocusTargetIcon(SettingDefinitions.ControlMode.AUTO_FOCUS, icon);
    }

    @Nullable
    public Drawable getAutoFocusContinuousIcon() {
        return this.focusTargetView.getFocusTargetIcon(SettingDefinitions.ControlMode.AUTO_FOCUS_CONTINUE);
    }

    public void setAutoFocusContinuousIcon(@DrawableRes int resourceId) {
        this.setAutoFocusContinuousIcon(this.getResources().getDrawable(resourceId));
    }

    public void setAutoFocusContinuousIcon(@Nullable Drawable icon) {
        this.focusTargetView.setFocusTargetIcon(SettingDefinitions.ControlMode.AUTO_FOCUS_CONTINUE, icon);
    }

    public void setAutoFocusAnimator(@AnimatorRes int animatorId) {
        this.focusTargetView.setAutoFocusAnimator(animatorId);
    }

    public long getFocusTargetDuration() {
        return this.focusTargetView.getFocusTargetDuration();
    }

    public void setFocusTargetDuration(long duration) {
        this.focusTargetView.setFocusTargetDuration(duration);
    }

    public float getCenterMeterScaleX() {
        return this.exposureMeterView.getCenterMeterScaleX();
    }

    public void setCenterMeterScaleX(float centerMeterScaleX) {
        this.exposureMeterView.setCenterMeterScaleX(centerMeterScaleX);
    }

    public float getCenterMeterScaleY() {
        return this.exposureMeterView.getCenterMeterScaleY();
    }

    public void setCenterMeterScaleY(float centerMeterScaleY) {
        this.exposureMeterView.setCenterMeterScaleY(centerMeterScaleY);
    }

    @Nullable
    public Drawable getGimbalPointIcon() {
        return this.gimbalControlView.getGimbalPointIcon();
    }

    public void setGimbalPointIcon(@DrawableRes int resourceId) {
        this.setGimbalPointIcon(this.getResources().getDrawable(resourceId));
    }

    public void setGimbalPointIcon(@Nullable Drawable gimbalPointIcon) {
        this.gimbalControlView.setGimbalPointIcon(gimbalPointIcon);
    }

    @Nullable
    public Drawable getGimbalMoveIcon() {
        return this.gimbalControlView.getGimbalMoveIcon();
    }

    public void setGimbalMoveIcon(@DrawableRes int resourceId) {
        this.setGimbalMoveIcon(this.getResources().getDrawable(resourceId));
    }

    public void setGimbalMoveIcon(@Nullable Drawable gimbalMoveIcon) {
        this.gimbalControlView.setGimbalMoveIcon(gimbalMoveIcon);
    }

    @Nullable
    public Drawable getGimbalArrowIcon() {
        return this.gimbalControlView.getGimbalArrowIcon();
    }

    public void setGimbalArrowIcon(@DrawableRes int resourceId) {
        this.setGimbalArrowIcon(this.getResources().getDrawable(resourceId));
    }

    public void setGimbalArrowIcon(@Nullable Drawable gimbalArrowIcon) {
        this.gimbalControlView.setGimbalArrowIcon(gimbalArrowIcon);
    }

    public float getGimbalVelocityFactor() {
        return this.velocityFactor;
    }

    public void setGimbalVelocityFactor(@FloatRange(from=1.0) float velocityFactor) {
        this.velocityFactor = velocityFactor;
    }

    public boolean isVibrationEnabled() {
        return this.gimbalControlView.isVibrationEnabled();
    }

    public void setVibrationEnabled(boolean vibrationEnabled) {
        this.gimbalControlView.setVibrationEnabled(vibrationEnabled);
    }

    public int getVibrationDuration() {
        return this.gimbalControlView.getVibrationDuration();
    }

    public void setVibrationDuration(@IntRange(from=0L) int vibrationDuration) {
        this.gimbalControlView.setVibrationDuration(vibrationDuration);
    }

    public boolean isInteractionEnabled() {
        return this.isInteractionEnabledAtomic.get();
    }

    public void setInteractionEnabled(boolean isInteractionEnabled) {
        this.isInteractionEnabledAtomic.set(isInteractionEnabled);
        this.updateVisibility();
    }

    public boolean isTouchFocusEnabled() {
        return this.touchFocusEnabled;
    }

    public void setTouchFocusEnabled(boolean isTouchFocusEnabled) {
        this.touchFocusEnabled = isTouchFocusEnabled;
    }

    public boolean isSpotMeteringEnabled() {
        return this.spotMeteringEnabled;
    }

    public void setSpotMeteringEnabled(boolean isSpotMeteringEnabled) {
        this.spotMeteringEnabled = isSpotMeteringEnabled;
    }

    public boolean isGimbalControlEnabled() {
        return this.gimbalControlEnabled;
    }

    public void setGimbalControlEnabled(boolean isGimbalControlEnabled) {
        this.gimbalControlEnabled = isGimbalControlEnabled;
    }
}

