/*
 * Decompiled with CFR 0.152.
 */
package dji.v5.ux.cameracore.widget.cameracapture;

import androidx.annotation.NonNull;
import dji.sdk.keyvalue.value.camera.CameraMode;
import dji.sdk.keyvalue.value.common.CameraLensType;
import dji.sdk.keyvalue.value.common.ComponentIndexType;
import dji.v5.ux.core.base.DJISDKModel;
import dji.v5.ux.core.base.ICameraIndex;
import dji.v5.ux.core.base.WidgetModel;
import dji.v5.ux.core.communication.ObservableInMemoryKeyedStore;
import dji.v5.ux.core.module.FlatCameraModule;
import io.reactivex.rxjava3.core.Flowable;

public class CameraCaptureWidgetModel
extends WidgetModel
implements ICameraIndex {
    private FlatCameraModule flatCameraModule;
    private ComponentIndexType cameraIndex = ComponentIndexType.LEFT_OR_MAIN;
    private CameraLensType lensType = CameraLensType.CAMERA_LENS_ZOOM;

    public CameraCaptureWidgetModel(@NonNull DJISDKModel djiSdkModel, @NonNull ObservableInMemoryKeyedStore keyedStore) {
        super(djiSdkModel, keyedStore);
        this.flatCameraModule = new FlatCameraModule();
        this.addModule(this.flatCameraModule);
    }

    @Override
    protected void inSetup() {
    }

    @Override
    protected void inCleanup() {
    }

    @Override
    public void updateCameraSource(@NonNull ComponentIndexType cameraIndex, @NonNull CameraLensType lensType) {
        this.cameraIndex = cameraIndex;
        this.lensType = lensType;
        this.flatCameraModule.updateCameraSource(cameraIndex, lensType);
        this.restart();
    }

    @Override
    @NonNull
    public ComponentIndexType getCameraIndex() {
        return this.cameraIndex;
    }

    @Override
    @NonNull
    public CameraLensType getLensType() {
        return this.lensType;
    }

    @Override
    protected void updateStates() {
    }

    public Flowable<CameraMode> getCameraMode() {
        return this.flatCameraModule.getCameraModeDataProcessor().toFlowable();
    }
}

